/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.string;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentString;
import fluent.types.FluentValue;
import java.util.List;
import java.util.Locale;

public class CaseFn
implements FluentFunction {
    public static final String NAME = "CASE";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        Style style = params.options().asEnum(Style.class, "style").orElse(Style.UPPER);
        Locale locale = scope.bundle().locale();
        return params.valuesAll().map(fv -> CaseFn.changeCase(fv, style, locale)).toList();
    }

    private static FluentValue<?> changeCase(FluentValue<?> in, Style style, Locale locale) {
        FluentValue<?> fluentValue = in;
        if (fluentValue instanceof FluentString) {
            FluentString fluentString = (FluentString)fluentValue;
            return switch (style) {
                case Style.UPPER -> FluentString.of((String)fluentString.value().toUpperCase(locale));
                case Style.LOWER -> FluentString.of((String)fluentString.value().toLowerCase(locale));
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return in;
    }

    private static enum Style {
        UPPER,
        LOWER;

    }
}

