/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.temporal;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionException;
import fluent.functions.FluentImplicit;
import fluent.functions.ImplicitFormatter;
import fluent.functions.Options;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentString;
import fluent.types.FluentTemporal;
import fluent.types.FluentValue;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemporalFn
implements FluentImplicit,
ImplicitFormatter {
    public FluentImplicit.Implicit id() {
        return FluentImplicit.Implicit.TEMPORAL;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        CustomDTF dtf = new CustomDTF(params.options(), scope.bundle().locale());
        return params.valuesAll().map(dtf::format).toList();
    }

    public String format(FluentValue<?> in, Scope scope) {
        CustomDTF dtf = new CustomDTF(scope.options(), scope.bundle().locale());
        return dtf.format(in).format(scope);
    }

    private static class CustomDTF {
        @NotNull
        private final Locale locale;
        @Nullable
        private final FormatStyle dateStyle;
        @Nullable
        private final FormatStyle timeStyle;
        @Nullable
        private final ZoneId tz;
        @Nullable
        private final DateTimeFormatter dtf;

        CustomDTF(Options opts, Locale locale) {
            this.locale = locale;
            this.tz = opts.into("timeZone", ZoneId::of).orElse(null);
            if (opts.has("pattern")) {
                this.dtf = ((DateTimeFormatter)opts.into("pattern", CustomDTF::parseDTFPattern).orElseThrow()).withLocale(locale).withZone(this.tz);
                this.timeStyle = null;
                this.dateStyle = null;
            } else {
                this.timeStyle = opts.asEnum(FormatStyle.class, "timeStyle").orElse(FormatStyle.MEDIUM);
                this.dateStyle = opts.asEnum(FormatStyle.class, "dateStyle").orElse(FormatStyle.MEDIUM);
                this.dtf = null;
            }
        }

        private static DateTimeFormatter parseDTFPattern(String in) {
            try {
                return DateTimeFormatter.ofPattern(in);
            }
            catch (IllegalArgumentException e) {
                throw FluentFunctionException.wrap((Throwable)e);
            }
        }

        FluentValue<?> format(FluentValue<?> in) {
            FluentValue<?> fluentValue = in;
            if (fluentValue instanceof FluentTemporal) {
                FluentTemporal temporal = (FluentTemporal)fluentValue;
                TemporalAccessor temporalAccessor = temporal.value();
                TemporalAccessor temporalAccessor2 = temporalAccessor;
                if (temporalAccessor2 instanceof Instant) {
                    Instant instant = (Instant)temporalAccessor2;
                    temporalAccessor = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                }
                DateTimeFormatter formatter = this.dtf;
                if (this.dtf == null) {
                    boolean hasTime;
                    boolean hasDate = temporalAccessor.query(TemporalQueries.localDate()) != null;
                    boolean bl = hasTime = temporalAccessor.query(TemporalQueries.localTime()) != null;
                    if (hasDate && hasTime) {
                        formatter = DateTimeFormatter.ofLocalizedDateTime(this.dateStyle, this.timeStyle).withLocale(this.locale);
                    } else if (hasDate) {
                        formatter = DateTimeFormatter.ofLocalizedDate(this.dateStyle).withLocale(this.locale);
                    } else if (hasTime) {
                        formatter = DateTimeFormatter.ofLocalizedTime(this.timeStyle).withLocale(this.locale);
                    } else {
                        throw FluentFunctionException.create((String)"No local date OR time for temporal: '%s'", (Object[])new Object[]{temporalAccessor});
                    }
                    formatter = formatter.withZone(this.tz);
                }
                assert (formatter != null);
                try {
                    return FluentString.of((String)formatter.format(temporalAccessor));
                }
                catch (DateTimeException e) {
                    throw FluentFunctionException.wrap((Throwable)e);
                }
            }
            return in;
        }
    }
}

