/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.content.ContentValues;
import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import net.sqlcipher.CrossProcessCursorWrapper;
import net.sqlcipher.Cursor;
import net.sqlcipher.CursorWrapper;
import net.sqlcipher.DatabaseErrorHandler;
import net.sqlcipher.DatabaseUtils;
import net.sqlcipher.DefaultDatabaseErrorHandler;
import net.sqlcipher.SQLException;
import net.sqlcipher.database.DatabaseObjectNotClosedException;
import net.sqlcipher.database.SQLiteClosable;
import net.sqlcipher.database.SQLiteCompiledSql;
import net.sqlcipher.database.SQLiteCursor;
import net.sqlcipher.database.SQLiteCursorDriver;
import net.sqlcipher.database.SQLiteDatabaseCorruptException;
import net.sqlcipher.database.SQLiteDatabaseHook;
import net.sqlcipher.database.SQLiteDebug;
import net.sqlcipher.database.SQLiteDirectCursorDriver;
import net.sqlcipher.database.SQLiteException;
import net.sqlcipher.database.SQLiteProgram;
import net.sqlcipher.database.SQLiteQuery;
import net.sqlcipher.database.SQLiteQueryBuilder;
import net.sqlcipher.database.SQLiteStatement;
import net.sqlcipher.database.SQLiteTransactionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends SQLiteClosable {
    private static final String TAG = "Database";
    private static final int EVENT_DB_OPERATION = 52000;
    private static final int EVENT_DB_CORRUPT = 75004;
    private static final String KEY_ENCODING = "UTF-8";
    public static final String SQLCIPHER_ANDROID_VERSION = "3.5.5";
    private static WeakHashMap<SQLiteDatabase, Object> sActiveDatabases = new WeakHashMap();
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    public static final int OPEN_READWRITE = 0;
    public static final int OPEN_READONLY = 1;
    private static final int OPEN_READ_MASK = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final String MEMORY = ":memory:";
    private boolean mInnerTransactionIsSuccessful;
    private boolean mTransactionIsSuccessful;
    private SQLiteTransactionListener mTransactionListener;
    private final ReentrantLock mLock = new ReentrantLock(true);
    private long mLockAcquiredWallTime = 0L;
    private long mLockAcquiredThreadTime = 0L;
    private static final int LOCK_WARNING_WINDOW_IN_MS = 20000;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS = 300;
    private static final int LOCK_ACQUIRED_WARNING_THREAD_TIME_IN_MS = 100;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS_ALWAYS_PRINT = 2000;
    private static final int SLEEP_AFTER_YIELD_QUANTUM = 1000;
    private static final Pattern EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    private long mLastLockMessageTime = 0L;
    private static int sQueryLogTimeInMillis = 0;
    private static final int QUERY_LOG_SQL_LENGTH = 64;
    private static final String COMMIT_SQL = "COMMIT;";
    private String mLastSqlStatement = null;
    static final String GET_LOCK_LOG_PREFIX = "GETLOCK:";
    long mNativeHandle = 0L;
    int mTempTableSequence = 0;
    private String mPath;
    private String mPathForLogs = null;
    private int mFlags;
    private CursorFactory mFactory;
    private WeakHashMap<SQLiteClosable, Object> mPrograms;
    Map<String, SQLiteCompiledSql> mCompiledQueries = new HashMap<String, SQLiteCompiledSql>();
    public static final int MAX_SQL_CACHE_SIZE = 250;
    private int mMaxSqlCacheSize = 250;
    private int mCacheFullWarnings;
    private static final int MAX_WARNINGS_ON_CACHESIZE_CONDITION = 1;
    private final DatabaseErrorHandler mErrorHandler;
    private int mNumCacheHits;
    private int mNumCacheMisses;
    private String mTimeOpened = null;
    private String mTimeClosed = null;
    private Throwable mStackTrace = null;
    private static final String LOG_SLOW_QUERIES_PROPERTY = "db.log.slow_query_threshold";
    private final int mSlowQueryThreshold;
    private boolean mLockingEnabled = true;
    private final Map<String, SyncUpdateInfo> mSyncUpdateInfo = new HashMap<String, SyncUpdateInfo>();

    public int status(int operation, boolean reset) {
        return this.native_status(operation, reset);
    }

    public void changePassword(String password) throws SQLiteException {
        if (!this.isOpen()) {
            throw new SQLiteException("database not open");
        }
        if (password != null) {
            byte[] keyMaterial = this.getBytes(password.toCharArray());
            this.rekey(keyMaterial);
            for (byte data : keyMaterial) {
                data = 0;
            }
        }
    }

    public void changePassword(char[] password) throws SQLiteException {
        if (!this.isOpen()) {
            throw new SQLiteException("database not open");
        }
        if (password != null) {
            byte[] keyMaterial = this.getBytes(password);
            this.rekey(keyMaterial);
            for (byte data : keyMaterial) {
                data = 0;
            }
        }
    }

    private static void loadICUData(Context context, File workingDir) {
        OutputStream out = null;
        ZipInputStream in = null;
        File icuDir = new File(workingDir, "icu");
        File icuDataFile = new File(icuDir, "icudt46l.dat");
        try {
            if (!icuDir.exists()) {
                icuDir.mkdirs();
            }
            if (!icuDataFile.exists()) {
                int len;
                in = new ZipInputStream(context.getAssets().open("icudt46l.zip"));
                in.getNextEntry();
                out = new FileOutputStream(icuDataFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Error copying icu dat file", (Throwable)ex);
            if (icuDataFile.exists()) {
                icuDataFile.delete();
            }
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ioe) {
                Log.e((String)TAG, (String)"Error in closing streams IO streams after expanding ICU dat file", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
    }

    public static synchronized void loadLibs(Context context) {
        SQLiteDatabase.loadLibs(context, context.getFilesDir());
    }

    public static synchronized void loadLibs(Context context, File workingDir) {
        System.loadLibrary("sqlcipher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.put(closable, null);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSQLiteClosable(SQLiteClosable closable) {
        this.lock();
        try {
            this.mPrograms.remove(closable);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAllReferencesReleased() {
        if (this.isOpen()) {
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                this.mTimeClosed = this.getTime();
            }
            this.dbclose();
            WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
            synchronized (weakHashMap) {
                sActiveDatabases.remove(this);
            }
        }
    }

    public static native int releaseMemory();

    public void setLockingEnabled(boolean lockingEnabled) {
        this.mLockingEnabled = lockingEnabled;
    }

    void onCorruption() {
        Log.e((String)TAG, (String)("Calling error handler for corrupt database (detected) " + this.mPath));
        this.mErrorHandler.onCorruption(this);
    }

    void lock() {
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.lock();
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
        }
    }

    private void lockForced() {
        this.mLock.lock();
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
        }
    }

    void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void unlockForced() {
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    private void checkLockHoldTime() {
        int threadTime;
        long elapsedTime = SystemClock.elapsedRealtime();
        long lockedTime = elapsedTime - this.mLockAcquiredWallTime;
        if (lockedTime < 2000L && !Log.isLoggable((String)TAG, (int)2) && elapsedTime - this.mLastLockMessageTime < 20000L) {
            return;
        }
        if (lockedTime > 300L && ((threadTime = (int)((Debug.threadCpuTimeNanos() - this.mLockAcquiredThreadTime) / 1000000L)) > 100 || lockedTime > 2000L)) {
            this.mLastLockMessageTime = elapsedTime;
            String msg = "lock held on " + this.mPath + " for " + lockedTime + "ms. Thread time was " + threadTime + "ms";
            if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING_STACK_TRACE) {
                Log.d((String)TAG, (String)msg, (Throwable)new Exception());
            } else {
                Log.d((String)TAG, (String)msg);
            }
        }
    }

    public void beginTransaction() {
        this.beginTransactionWithListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.lockForced();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        boolean ok = false;
        try {
            if (this.mLock.getHoldCount() > 1) {
                if (this.mInnerTransactionIsSuccessful) {
                    String msg = "Cannot call beginTransaction between calling setTransactionSuccessful and endTransaction";
                    IllegalStateException e = new IllegalStateException(msg);
                    Log.e((String)TAG, (String)"beginTransaction() failed", (Throwable)e);
                    throw e;
                }
                ok = true;
                return;
            }
            this.execSQL("BEGIN EXCLUSIVE;");
            this.mTransactionListener = transactionListener;
            this.mTransactionIsSuccessful = true;
            this.mInnerTransactionIsSuccessful = false;
            if (transactionListener != null) {
                try {
                    transactionListener.onBegin();
                }
                catch (RuntimeException e) {
                    this.execSQL("ROLLBACK;");
                    throw e;
                }
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.unlockForced();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        block18: {
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            if (!this.mLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("no transaction pending");
            }
            try {
                if (this.mInnerTransactionIsSuccessful) {
                    this.mInnerTransactionIsSuccessful = false;
                } else {
                    this.mTransactionIsSuccessful = false;
                }
                if (this.mLock.getHoldCount() != 1) {
                    return;
                }
                RuntimeException savedException = null;
                if (this.mTransactionListener != null) {
                    try {
                        if (this.mTransactionIsSuccessful) {
                            this.mTransactionListener.onCommit();
                        } else {
                            this.mTransactionListener.onRollback();
                        }
                    }
                    catch (RuntimeException e) {
                        savedException = e;
                        this.mTransactionIsSuccessful = false;
                    }
                }
                if (this.mTransactionIsSuccessful) {
                    this.execSQL(COMMIT_SQL);
                    break block18;
                }
                try {
                    this.execSQL("ROLLBACK;");
                    if (savedException != null) {
                        throw savedException;
                    }
                }
                catch (SQLException e) {
                    Log.d((String)TAG, (String)"exception during rollback, maybe the DB previously performed an auto-rollback");
                }
            }
            finally {
                this.mTransactionListener = null;
                this.unlockForced();
            }
        }
    }

    public void setTransactionSuccessful() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        if (this.mInnerTransactionIsSuccessful) {
            throw new IllegalStateException("setTransactionSuccessful may only be called once per call to beginTransaction");
        }
        this.mInnerTransactionIsSuccessful = true;
    }

    public boolean inTransaction() {
        return this.mLock.getHoldCount() > 0;
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mLock.isHeldByCurrentThread();
    }

    public boolean isDbLockedByOtherThreads() {
        return !this.mLock.isHeldByCurrentThread() && this.mLock.isLocked();
    }

    @Deprecated
    public boolean yieldIfContended() {
        if (!this.isOpen()) {
            return false;
        }
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        if (!this.isOpen()) {
            return false;
        }
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        if (!this.isOpen()) {
            return false;
        }
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    private boolean yieldIfContendedHelper(boolean checkFullyYielded, long sleepAfterYieldDelay) {
        if (this.mLock.getQueueLength() == 0) {
            this.mLockAcquiredWallTime = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = Debug.threadCpuTimeNanos();
            return false;
        }
        this.setTransactionSuccessful();
        SQLiteTransactionListener transactionListener = this.mTransactionListener;
        this.endTransaction();
        if (checkFullyYielded && this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Db locked more than once. yielfIfContended cannot yield");
        }
        if (sleepAfterYieldDelay > 0L) {
            for (long remainingDelay = sleepAfterYieldDelay; remainingDelay > 0L; remainingDelay -= 1000L) {
                try {
                    Thread.sleep(remainingDelay < 1000L ? remainingDelay : 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                if (this.mLock.getQueueLength() != 0) continue;
            }
        }
        this.beginTransactionWithListener(transactionListener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSyncedTables() {
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            HashMap<String, String> tables = new HashMap<String, String>();
            for (String table : this.mSyncUpdateInfo.keySet()) {
                SyncUpdateInfo info = this.mSyncUpdateInfo.get(table);
                if (info.deletedTable == null) continue;
                tables.put(table, info.deletedTable);
            }
            return tables;
        }
    }

    public static SQLiteDatabase openDatabase(String path, String password, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, password, factory, flags, null);
    }

    public static SQLiteDatabase openDatabase(String path, char[] password, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, password, factory, flags, null, null);
    }

    public static SQLiteDatabase openDatabase(String path, String password, CursorFactory factory, int flags, SQLiteDatabaseHook hook) {
        return SQLiteDatabase.openDatabase(path, password, factory, flags, hook, null);
    }

    public static SQLiteDatabase openDatabase(String path, char[] password, CursorFactory factory, int flags, SQLiteDatabaseHook hook) {
        return SQLiteDatabase.openDatabase(path, password, factory, flags, hook, null);
    }

    public static SQLiteDatabase openDatabase(String path, String password, CursorFactory factory, int flags, SQLiteDatabaseHook hook, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, password == null ? null : password.toCharArray(), factory, flags, hook, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteDatabase openDatabase(String path, char[] password, CursorFactory factory, int flags, SQLiteDatabaseHook hook, DatabaseErrorHandler errorHandler) {
        SQLiteDatabase sqliteDatabase = null;
        DatabaseErrorHandler myErrorHandler = errorHandler != null ? errorHandler : new DefaultDatabaseErrorHandler();
        try {
            sqliteDatabase = new SQLiteDatabase(path, factory, flags, myErrorHandler);
            sqliteDatabase.openDatabaseInternal(password, hook);
        }
        catch (SQLiteDatabaseCorruptException e) {
            Log.e((String)TAG, (String)("Calling error handler for corrupt database " + path), (Throwable)e);
            myErrorHandler.onCorruption(sqliteDatabase);
            sqliteDatabase = new SQLiteDatabase(path, factory, flags, myErrorHandler);
            sqliteDatabase.openDatabaseInternal(password, hook);
        }
        if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
            sqliteDatabase.enableSqlTracing(path);
        }
        if (SQLiteDebug.DEBUG_SQL_TIME) {
            sqliteDatabase.enableSqlProfiling(path);
        }
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(sqliteDatabase, null);
        }
        return sqliteDatabase;
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, String password, CursorFactory factory, SQLiteDatabaseHook databaseHook) {
        return SQLiteDatabase.openOrCreateDatabase(file, password, factory, databaseHook, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, String password, CursorFactory factory, SQLiteDatabaseHook databaseHook) {
        return SQLiteDatabase.openDatabase(path, password, factory, 0x10000000, databaseHook);
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, String password, CursorFactory factory, SQLiteDatabaseHook databaseHook, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openOrCreateDatabase(file == null ? null : file.getPath(), password, factory, databaseHook, errorHandler);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, String password, CursorFactory factory, SQLiteDatabaseHook databaseHook, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, password == null ? null : password.toCharArray(), factory, 0x10000000, databaseHook, errorHandler);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, char[] password, CursorFactory factory, SQLiteDatabaseHook databaseHook) {
        return SQLiteDatabase.openDatabase(path, password, factory, 0x10000000, databaseHook);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, char[] password, CursorFactory factory, SQLiteDatabaseHook databaseHook, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, password, factory, 0x10000000, databaseHook, errorHandler);
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, String password, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file, password, factory, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, String password, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, password, factory, 0x10000000, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, char[] password, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, password, factory, 0x10000000, null);
    }

    public static SQLiteDatabase create(CursorFactory factory, String password) {
        return SQLiteDatabase.openDatabase(MEMORY, password == null ? null : password.toCharArray(), factory, 0x10000000);
    }

    public static SQLiteDatabase create(CursorFactory factory, char[] password) {
        return SQLiteDatabase.openDatabase(MEMORY, password, factory, 0x10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.lock();
        try {
            this.closeClosable();
            this.onAllReferencesReleased();
        }
        finally {
            this.unlock();
        }
    }

    private void closeClosable() {
        this.deallocCachedSqlStatements();
        for (Map.Entry<SQLiteClosable, Object> entry : this.mPrograms.entrySet()) {
            SQLiteClosable program = entry.getKey();
            if (program == null) continue;
            program.onAllReferencesReleasedFromContainer();
        }
    }

    private native void dbclose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            prog = new SQLiteStatement(this, "PRAGMA user_version;");
            long version = prog.simpleQueryForLong();
            int n = (int)version;
            return n;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaximumSize() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            prog = new SQLiteStatement(this, "PRAGMA max_page_count;");
            long pageCount = prog.simpleQueryForLong();
            long l = pageCount * this.getPageSize();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMaximumSize(long numBytes) {
        SQLiteProgram prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            long pageSize = this.getPageSize();
            long numPages = numBytes / pageSize;
            if (numBytes % pageSize != 0L) {
                ++numPages;
            }
            prog = new SQLiteStatement(this, "PRAGMA max_page_count = " + numPages);
            long newPageCount = ((SQLiteStatement)prog).simpleQueryForLong();
            long l = newPageCount * pageSize;
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPageSize() {
        SQLiteStatement prog = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            long size;
            prog = new SQLiteStatement(this, "PRAGMA page_size;");
            long l = size = prog.simpleQueryForLong();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
            this.unlock();
        }
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    public void markTableSyncable(String table, String deletedTable) {
        if (!this.isOpen()) {
            throw new SQLiteException("database not open");
        }
        this.markTableSyncable(table, "_id", table, deletedTable);
    }

    public void markTableSyncable(String table, String foreignKey, String updateTable) {
        if (!this.isOpen()) {
            throw new SQLiteException("database not open");
        }
        this.markTableSyncable(table, foreignKey, updateTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markTableSyncable(String table, String foreignKey, String updateTable, String deletedTable) {
        this.lock();
        try {
            this.native_execSQL("SELECT _sync_dirty FROM " + updateTable + " LIMIT 0");
            this.native_execSQL("SELECT " + foreignKey + " FROM " + table + " LIMIT 0");
        }
        finally {
            this.unlock();
        }
        SyncUpdateInfo info = new SyncUpdateInfo(updateTable, deletedTable, foreignKey);
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            this.mSyncUpdateInfo.put(table, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowUpdated(String table, long rowId) {
        SyncUpdateInfo info;
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            info = this.mSyncUpdateInfo.get(table);
        }
        if (info != null) {
            this.execSQL("UPDATE " + info.masterTable + " SET _sync_dirty=1 WHERE _id=(SELECT " + info.foreignKey + " FROM " + table + " WHERE _id=" + rowId + ")");
        }
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty((CharSequence)tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql);
            return sQLiteStatement;
        }
        finally {
            this.unlock();
        }
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table));
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        long timeStart = 0L;
        if (this.mSlowQueryThreshold != -1) {
            timeStart = System.currentTimeMillis();
        }
        SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable);
        Cursor cursor = null;
        try {
            cursor = driver.query(cursorFactory != null ? cursorFactory : this.mFactory, selectionArgs);
        }
        finally {
            if (this.mSlowQueryThreshold != -1) {
                long duration;
                int count = -1;
                if (cursor != null) {
                    count = cursor.getCount();
                }
                if ((duration = System.currentTimeMillis() - timeStart) >= (long)this.mSlowQueryThreshold) {
                    Log.v((String)TAG, (String)("query (" + duration + " ms): " + ((Object)driver).toString() + ", args are <redacted>, count is " + count));
                }
            }
        }
        return new CrossProcessCursorWrapper(cursor);
    }

    public Cursor rawQuery(String sql, String[] selectionArgs, int initialRead, int maxRead) {
        CursorWrapper cursorWrapper = (CursorWrapper)this.rawQueryWithFactory(null, sql, selectionArgs, null);
        ((SQLiteCursor)cursorWrapper.getWrappedCursor()).setLoadStyle(initialRead, maxRead);
        return cursorWrapper;
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error inserting <redacted values> into " + table), (Throwable)e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error inserting <redacted values> into " + table), (Throwable)e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        StringBuilder sql = new StringBuilder(152);
        sql.append("INSERT");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(" INTO ");
        sql.append(table);
        StringBuilder values = new StringBuilder(40);
        Set entrySet = null;
        if (initialValues != null && initialValues.size() > 0) {
            entrySet = initialValues.valueSet();
            Iterator entriesIter = entrySet.iterator();
            sql.append('(');
            boolean needSeparator = false;
            while (entriesIter.hasNext()) {
                if (needSeparator) {
                    sql.append(", ");
                    values.append(", ");
                }
                needSeparator = true;
                Map.Entry entry = (Map.Entry)entriesIter.next();
                sql.append((String)entry.getKey());
                values.append('?');
            }
            sql.append(')');
        } else {
            sql.append("(" + nullColumnHack + ") ");
            values.append("NULL");
        }
        sql.append(" VALUES(");
        sql.append((CharSequence)values);
        sql.append(");");
        this.lock();
        SQLiteStatement statement = null;
        try {
            statement = this.compileStatement(sql.toString());
            if (entrySet != null) {
                int size = entrySet.size();
                Iterator entriesIter = entrySet.iterator();
                for (int i = 0; i < size; ++i) {
                    Map.Entry entry = (Map.Entry)entriesIter.next();
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, entry.getValue());
                }
            }
            statement.execute();
            long insertedRowId = this.lastInsertRow();
            if (insertedRowId == -1L) {
                Log.e((String)TAG, (String)("Error inserting <redacted values> using <redacted sql> into " + table));
            } else if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Inserting row " + insertedRowId + " from <redacted values> using <redacted sql> into " + table));
            }
            long l = insertedRowId;
            return l;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        SQLiteProgram statement = null;
        try {
            int numArgs;
            statement = this.compileStatement("DELETE FROM " + table + (!TextUtils.isEmpty((CharSequence)whereClause) ? " WHERE " + whereClause : ""));
            if (whereArgs != null) {
                numArgs = whereArgs.length;
                for (int i = 0; i < numArgs; ++i) {
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, whereArgs[i]);
                }
            }
            ((SQLiteStatement)statement).execute();
            numArgs = this.lastChangeCount();
            return numArgs;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(table);
        sql.append(" SET ");
        Set entrySet = values.valueSet();
        Iterator entriesIter = entrySet.iterator();
        while (entriesIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entriesIter.next();
            sql.append((String)entry.getKey());
            sql.append("=?");
            if (!entriesIter.hasNext()) continue;
            sql.append(", ");
        }
        if (!TextUtils.isEmpty((CharSequence)whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        SQLiteStatement statement = null;
        try {
            int i;
            statement = this.compileStatement(sql.toString());
            int size = entrySet.size();
            entriesIter = entrySet.iterator();
            int bindArg = 1;
            for (i = 0; i < size; ++i) {
                Map.Entry entry = (Map.Entry)entriesIter.next();
                DatabaseUtils.bindObjectToProgram(statement, bindArg, entry.getValue());
                ++bindArg;
            }
            if (whereArgs != null) {
                size = whereArgs.length;
                for (i = 0; i < size; ++i) {
                    statement.bindString(bindArg, whereArgs[i]);
                    ++bindArg;
                }
            }
            statement.execute();
            int numChangedRows = this.lastChangeCount();
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Updated " + numChangedRows + " rows using <redacted values> and <redacted sql> for " + table));
            }
            int n = numChangedRows;
            return n;
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error updating <redacted values> using <redacted sql> for " + table));
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    public void execSQL(String sql) throws SQLException {
        long timeStart = SystemClock.uptimeMillis();
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            this.native_execSQL(sql);
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            this.unlock();
        }
    }

    public void rawExecSQL(String sql) {
        long timeStart = SystemClock.uptimeMillis();
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            this.native_rawExecSQL(sql);
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            this.unlock();
        }
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        SQLiteStatement statement = null;
        try {
            statement = this.compileStatement(sql);
            if (bindArgs != null) {
                int numArgs = bindArgs.length;
                for (int i = 0; i < numArgs; ++i) {
                    DatabaseUtils.bindObjectToProgram(statement, i + 1, bindArgs[i]);
                }
            }
            statement.execute();
        }
        catch (SQLiteDatabaseCorruptException e) {
            this.onCorruption();
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.unlock();
        }
    }

    protected void finalize() {
        if (this.isOpen()) {
            Log.e((String)TAG, (String)("close() was never explicitly called on database '" + this.mPath + "' "), (Throwable)this.mStackTrace);
            this.closeClosable();
            this.onAllReferencesReleased();
        }
    }

    public SQLiteDatabase(String path, char[] password, CursorFactory factory, int flags) {
        this(path, factory, flags, null);
        this.openDatabaseInternal(password, null);
    }

    public SQLiteDatabase(String path, char[] password, CursorFactory factory, int flags, SQLiteDatabaseHook databaseHook) {
        this(path, factory, flags, null);
        this.openDatabaseInternal(password, databaseHook);
    }

    private SQLiteDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler) {
        if (path == null) {
            throw new IllegalArgumentException("path should not be null");
        }
        this.mFlags = flags;
        this.mPath = path;
        this.mSlowQueryThreshold = -1;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mFactory = factory;
        this.mPrograms = new WeakHashMap();
        this.mErrorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDatabaseInternal(final char[] password, SQLiteDatabaseHook hook) {
        block10: {
            boolean shouldCloseConnection = true;
            final byte[] keyMaterial = this.getBytes(password);
            this.dbopen(this.mPath, this.mFlags);
            try {
                this.keyDatabase(hook, new Runnable(){

                    public void run() {
                        if (keyMaterial != null && keyMaterial.length > 0) {
                            SQLiteDatabase.this.key(keyMaterial);
                        }
                    }
                });
                shouldCloseConnection = false;
            }
            catch (RuntimeException ex) {
                if (this.containsNull(password)) {
                    this.keyDatabase(hook, new Runnable(){

                        public void run() {
                            if (password != null) {
                                SQLiteDatabase.this.key_mutf8(password);
                            }
                        }
                    });
                    if (keyMaterial != null && keyMaterial.length > 0) {
                        this.rekey(keyMaterial);
                    }
                    shouldCloseConnection = false;
                }
                throw ex;
            }
            finally {
                if (shouldCloseConnection) {
                    this.dbclose();
                    if (SQLiteDebug.DEBUG_SQL_CACHE) {
                        this.mTimeClosed = this.getTime();
                    }
                }
                if (keyMaterial == null || keyMaterial.length <= 0) break block10;
                for (byte data : keyMaterial) {
                    data = 0;
                }
            }
        }
    }

    private boolean containsNull(char[] data) {
        char defaultValue = '\u0000';
        boolean status = false;
        if (data != null && data.length > 0) {
            for (char datum : data) {
                if (datum != defaultValue) continue;
                status = true;
                break;
            }
        }
        return status;
    }

    private void keyDatabase(SQLiteDatabaseHook databaseHook, Runnable keyOperation) {
        if (databaseHook != null) {
            databaseHook.preKey(this);
        }
        if (keyOperation != null) {
            keyOperation.run();
        }
        if (databaseHook != null) {
            databaseHook.postKey(this);
        }
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            this.mTimeOpened = this.getTime();
        }
        try {
            Cursor cursor = this.rawQuery("select count(*) from sqlite_master;", new String[0]);
            if (cursor != null) {
                cursor.moveToFirst();
                int count = cursor.getInt(0);
                cursor.close();
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String getTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ").format(System.currentTimeMillis());
    }

    public boolean isReadOnly() {
        return (this.mFlags & 1) == 1;
    }

    public boolean isOpen() {
        return this.mNativeHandle != 0L;
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    public final String getPath() {
        return this.mPath;
    }

    private String getPathForLogs() {
        if (this.mPathForLogs != null) {
            return this.mPathForLogs;
        }
        if (this.mPath == null) {
            return null;
        }
        this.mPathForLogs = this.mPath.indexOf(64) == -1 ? this.mPath : EMAIL_IN_DB_PATTERN.matcher(this.mPath).replaceAll("XX@YY");
        return this.mPathForLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        this.lock();
        try {
            this.native_setLocale(locale.toString(), this.mFlags);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCompiledQueries(String sql, SQLiteCompiledSql compiledStatement) {
        if (this.mMaxSqlCacheSize == 0) {
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                Log.v((String)TAG, (String)("|NOT adding_sql_to_cache|" + this.getPath() + "|" + sql));
            }
            return;
        }
        SQLiteCompiledSql compiledSql = null;
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            compiledSql = this.mCompiledQueries.get(sql);
            if (compiledSql != null) {
                return;
            }
            if (this.mCompiledQueries.size() == this.mMaxSqlCacheSize) {
                if (++this.mCacheFullWarnings == 1) {
                    Log.w((String)TAG, (String)("Reached MAX size for compiled-sql statement cache for database " + this.getPath() + "; i.e., NO space for this sql statement in cache: " + sql + ". Please change your sql statements to use '?' for " + "bindargs, instead of using actual values"));
                }
            } else {
                this.mCompiledQueries.put(sql, compiledStatement);
                if (SQLiteDebug.DEBUG_SQL_CACHE) {
                    Log.v((String)TAG, (String)("|adding_sql_to_cache|" + this.getPath() + "|" + this.mCompiledQueries.size() + "|" + sql));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocCachedSqlStatements() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            for (SQLiteCompiledSql compiledSql : this.mCompiledQueries.values()) {
                compiledSql.releaseSqlStatement();
            }
            this.mCompiledQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLiteCompiledSql getCompiledStatementForSql(String sql) {
        boolean cacheHit;
        SQLiteCompiledSql compiledStatement = null;
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            if (this.mMaxSqlCacheSize == 0) {
                if (SQLiteDebug.DEBUG_SQL_CACHE) {
                    Log.v((String)TAG, (String)("|cache NOT found|" + this.getPath()));
                }
                return null;
            }
            compiledStatement = this.mCompiledQueries.get(sql);
            cacheHit = compiledStatement != null;
        }
        if (cacheHit) {
            ++this.mNumCacheHits;
        } else {
            ++this.mNumCacheMisses;
        }
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            Log.v((String)TAG, (String)("|cache_stats|" + this.getPath() + "|" + this.mCompiledQueries.size() + "|" + this.mNumCacheHits + "|" + this.mNumCacheMisses + "|" + cacheHit + "|" + this.mTimeOpened + "|" + this.mTimeClosed + "|" + sql));
        }
        return compiledStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCompiledSqlCache(String sql) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            return this.mCompiledQueries.containsKey(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeFromCompiledSqlCache(String sql) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            this.mCompiledQueries.remove(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCompiledSqlCache() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            this.mCompiledQueries.clear();
        }
    }

    public synchronized int getMaxSqlCacheSize() {
        return this.mMaxSqlCacheSize;
    }

    public synchronized void setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 250 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 250");
        }
        if (cacheSize < this.mMaxSqlCacheSize) {
            throw new IllegalStateException("cannot set cacheSize to a value less than the value set with previous setMaxSqlCacheSize() call.");
        }
        this.mMaxSqlCacheSize = cacheSize;
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            String path;
            if (db == null || !db.isOpen()) continue;
            int lookasideUsed = db.native_getDbLookaside();
            int indx = (path = db.getPath()).lastIndexOf("/");
            String lastnode = path.substring(indx != -1 ? ++indx : 0);
            ArrayList<Pair<String, String>> attachedDbs = SQLiteDatabase.getAttachedDbs(db);
            if (attachedDbs == null) continue;
            for (int i = 0; i < attachedDbs.size(); ++i) {
                String dbName;
                Pair<String, String> p = attachedDbs.get(i);
                long pageCount = SQLiteDatabase.getPragmaVal(db, (String)p.first + ".page_count;");
                if (i == 0) {
                    dbName = lastnode;
                } else {
                    lookasideUsed = 0;
                    dbName = "  (attached) " + (String)p.first;
                    if (((String)p.second).trim().length() > 0) {
                        int idx = ((String)p.second).lastIndexOf("/");
                        dbName = dbName + " : " + ((String)p.second).substring(idx != -1 ? ++idx : 0);
                    }
                }
                if (pageCount <= 0L) continue;
                dbStatsList.add(new SQLiteDebug.DbStats(dbName, pageCount, db.getPageSize(), lookasideUsed));
            }
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        ArrayList<SQLiteDatabase> databases = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            databases.addAll(sActiveDatabases.keySet());
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPragmaVal(SQLiteDatabase db, String pragma) {
        if (!db.isOpen()) {
            return 0L;
        }
        SQLiteProgram prog = null;
        try {
            long val;
            prog = new SQLiteStatement(db, "PRAGMA " + pragma);
            long l = val = ((SQLiteStatement)prog).simpleQueryForLong();
            return l;
        }
        finally {
            if (prog != null) {
                prog.close();
            }
        }
    }

    private static ArrayList<Pair<String, String>> getAttachedDbs(SQLiteDatabase dbObj) {
        if (!dbObj.isOpen()) {
            return null;
        }
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Cursor c = dbObj.rawQuery("pragma database_list;", null);
        while (c.moveToNext()) {
            attachedDbs.add((Pair<String, String>)new Pair((Object)c.getString(1), (Object)c.getString(2)));
        }
        c.close();
        return attachedDbs;
    }

    private byte[] getBytes(char[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(data);
        ByteBuffer byteBuffer = Charset.forName(KEY_ENCODING).encode(charBuffer);
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    public static native void setICURoot(String var0);

    private native void dbopen(String var1, int var2);

    private native void enableSqlTracing(String var1);

    private native void enableSqlProfiling(String var1);

    native void native_execSQL(String var1) throws SQLException;

    native void native_setLocale(String var1, int var2);

    native long lastInsertRow();

    native int lastChangeCount();

    private native int native_getDbLookaside();

    private native void native_rawExecSQL(String var1);

    private native int native_status(int var1, boolean var2);

    private native void native_key(char[] var1) throws SQLException;

    private native void native_rekey(String var1) throws SQLException;

    private native void key(byte[] var1) throws SQLException;

    private native void key_mutf8(char[] var1) throws SQLException;

    private native void rekey(byte[] var1) throws SQLException;

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    private static class SyncUpdateInfo {
        String masterTable;
        String deletedTable;
        String foreignKey;

        SyncUpdateInfo(String masterTable, String deletedTable, String foreignKey) {
            this.masterTable = masterTable;
            this.deletedTable = deletedTable;
            this.foreignKey = foreignKey;
        }
    }
}

