/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database;

import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.util.List;
import net.zetetic.database.DatabaseErrorHandler;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteException;

public final class DefaultDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final String TAG = "DefaultDatabaseErrorHandler";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCorruption(SQLiteDatabase dbObj) {
        block13: {
            block12: {
                Log.e((String)TAG, (String)("Corruption reported by sqlite on database: " + dbObj.getPath()));
                if (SQLiteDatabase.hasCodec()) {
                    return;
                }
                if (!dbObj.isOpen()) {
                    this.deleteDatabaseFile(dbObj.getPath());
                    return;
                }
                List<Pair<String, String>> attachedDbs = null;
                try {
                    try {
                        attachedDbs = dbObj.getAttachedDbs();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    try {
                        dbObj.close();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    if (attachedDbs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (attachedDbs != null) {
                        for (Pair<String, String> p : attachedDbs) {
                            this.deleteDatabaseFile((String)p.second);
                        }
                    } else {
                        this.deleteDatabaseFile(dbObj.getPath());
                    }
                    throw throwable;
                }
                for (Pair<String, String> p : attachedDbs) {
                    this.deleteDatabaseFile((String)p.second);
                }
                break block13;
            }
            this.deleteDatabaseFile(dbObj.getPath());
        }
    }

    private void deleteDatabaseFile(String fileName) {
        if (fileName.equalsIgnoreCase(":memory:") || fileName.trim().length() == 0) {
            return;
        }
        Log.e((String)TAG, (String)("deleting the database file: " + fileName));
        try {
            SQLiteDatabase.deleteDatabase(new File(fileName));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("delete failed: " + e.getMessage()));
        }
    }
}

