/*
 * Decompiled with CFR 0.152.
 */
package net.zileo.logback.logdna;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import net.zileo.logback.logdna.LogDnaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDnaAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String CUSTOM_USER_AGENT = "LogDna Logback Appender";
    private final Logger errorLog = LoggerFactory.getLogger(LogDnaAppender.class);
    private final ObjectMapper dataMapper;
    private final ObjectMapper responseMapper;
    private Client client;
    private boolean disabled;
    protected final MultivaluedMap<String, Object> headers;
    protected String hostname;
    protected PatternLayoutEncoder encoder;
    protected String appName;
    protected String ingestUrl = "https://logs.logdna.com/logs/ingest";
    protected List<String> mdcFields = new ArrayList<String>();
    protected List<String> mdcTypes = new ArrayList<String>();
    protected String tags;
    protected long connectTimeout = 0L;
    protected long readTimeout = 0L;
    protected boolean useTimeDrift = true;

    public LogDnaAppender() {
        this.headers = new MultivaluedHashMap();
        this.headers.add((Object)"User-Agent", (Object)CUSTOM_USER_AGENT);
        this.headers.add((Object)"Accept", (Object)"application/json");
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.dataMapper = new ObjectMapper();
        this.dataMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.dataMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        this.responseMapper = new ObjectMapper();
        this.responseMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private String identifyHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    protected Client client() {
        if (this.client == null) {
            if (this.hostname == null) {
                this.hostname = this.identifyHostname();
            }
            this.client = ClientBuilder.newBuilder().connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).build();
        }
        return this.client;
    }

    protected void append(ILoggingEvent event) {
        if (this.disabled) {
            return;
        }
        if (event.getLoggerName().equals(LogDnaAppender.class.getName())) {
            return;
        }
        if (!this.headers.containsKey((Object)"apikey") || this.headers.getFirst((Object)"apikey").toString().trim().length() == 0) {
            this.errorLog.warn("Empty ingest API key for LogDNA ; disabling LogDnaAppender");
            this.disabled = true;
            return;
        }
        try {
            String jsonData = this.convertLogEventToJson(event);
            Response response = this.callIngestApi(jsonData);
            if (response.getStatus() != 200) {
                LogDnaResponse logDnaResponse = this.convertResponseToObject(response);
                this.errorLog.error("Error calling LogDna : {} ({})", (Object)logDnaResponse.getError(), (Object)response.getStatus());
            }
        }
        catch (JsonProcessingException e) {
            this.errorLog.error("Error processing JSON data : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.errorLog.error("Error calling LogDna : {}", (Object)e.getMessage());
        }
    }

    protected String convertLogEventToJson(ILoggingEvent event) throws JsonProcessingException {
        return this.dataMapper.writeValueAsString(this.buildPostData(event));
    }

    protected LogDnaResponse convertResponseToObject(Response response) throws JsonProcessingException {
        return (LogDnaResponse)this.responseMapper.readValue((String)response.readEntity(String.class), LogDnaResponse.class);
    }

    protected Response callIngestApi(String jsonData) {
        WebTarget wt = this.client().target(this.ingestUrl).queryParam("hostname", new Object[]{this.hostname}).queryParam("tags", new Object[]{this.tags});
        if (this.useTimeDrift) {
            wt = wt.queryParam("now", new Object[]{System.currentTimeMillis()});
        }
        return wt.request().headers(this.headers).post(Entity.json((Object)jsonData));
    }

    protected Map<String, Object> buildPostData(ILoggingEvent event) {
        HashMap<String, Object> line = new HashMap<String, Object>();
        line.put("timestamp", event.getTimeStamp());
        line.put("level", event.getLevel().toString());
        line.put("app", this.appName);
        line.put("line", this.encoder != null ? new String(this.encoder.encode((Object)event)) : event.getFormattedMessage());
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("logger", event.getLoggerName());
        if (!this.mdcFields.isEmpty() && !event.getMDCPropertyMap().isEmpty()) {
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                if (!this.mdcFields.contains(entry.getKey())) continue;
                String type = this.mdcTypes.get(this.mdcFields.indexOf(entry.getKey()));
                meta.put((String)entry.getKey(), this.getMetaValue(type, (String)entry.getValue()));
            }
        }
        line.put("meta", meta);
        HashMap<String, Object> lines = new HashMap<String, Object>();
        lines.put("lines", Arrays.asList(line));
        return lines;
    }

    private Object getMetaValue(String type, String value) {
        try {
            if ("int".equals(type)) {
                return Integer.valueOf(value);
            }
            if ("long".equals(type)) {
                return Long.valueOf(value);
            }
            if ("boolean".equals(type)) {
                return Boolean.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            this.errorLog.warn("Error getting meta value : {}", (Object)e.getMessage());
        }
        return value;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
    }

    public void setIngestKey(String ingestKey) {
        this.headers.add((Object)"apikey", (Object)ingestKey);
    }

    public void setMdcFields(String mdcFields) {
        this.mdcFields = Arrays.asList(mdcFields.split(","));
    }

    public void setMdcTypes(String mdcTypes) {
        this.mdcTypes = Arrays.asList(mdcTypes.split(","));
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setUseTimeDrift(String useTimeDrift) {
        this.useTimeDrift = !useTimeDrift.equalsIgnoreCase("false");
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

