/*
 * Decompiled with CFR 0.152.
 */
package net.zscript.maven.templating.contextloader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LoadableEntities {
    private final URI rootPath;
    private final List<String> relativePaths;
    private final String fileTypeSuffix;
    private final FileSystem fileSystem;

    public LoadableEntities(URI rootPath, List<String> relativePaths, String fileTypeSuffix, FileSystem fileSystem) {
        if (!rootPath.getPath().endsWith("/")) {
            throw new IllegalArgumentException("Invalid directory URI - missing '/'? " + rootPath);
        }
        this.rootPath = rootPath;
        this.relativePaths = relativePaths;
        this.fileTypeSuffix = fileTypeSuffix;
        this.fileSystem = fileSystem;
    }

    public List<LoadedEntityScopes> loadEntities(Function<LoadableEntity, List<LoadedEntityScopes>> loader) {
        return this.relativePaths.stream().map(x$0 -> new LoadableEntity((String)x$0)).map(loader).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public class LoadedEntityScopes
    extends LoadableEntity {
        private final List<Object> scopes;
        private final Path relativeOutputPath;

        private LoadedEntityScopes(String relativePath, List<Object> scopes, Path relativeOutputPath) {
            super(relativePath);
            this.scopes = scopes;
            if (relativeOutputPath.isAbsolute()) {
                throw new IllegalArgumentException("relativeOutputPath is absolute: " + relativeOutputPath);
            }
            this.relativeOutputPath = relativeOutputPath;
        }

        public List<Object> getScopes() {
            return this.scopes;
        }

        public Path getRelativeOutputPath() {
            return this.relativeOutputPath;
        }
    }

    public class LoadableEntity {
        private final String relativePath;

        public LoadableEntity(String relativePath) {
            if (LoadableEntities.this.fileSystem.getPath(relativePath, new String[0]).isAbsolute()) {
                throw new IllegalArgumentException("relativePath is absolute: " + relativePath);
            }
            this.relativePath = relativePath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public URI getRootPath() {
            return LoadableEntities.this.rootPath;
        }

        public String getFileTypeSuffix() {
            return LoadableEntities.this.fileTypeSuffix;
        }

        public FileSystem getFileSystem() {
            return LoadableEntities.this.fileSystem;
        }

        public URI getFullPath() {
            return LoadableEntities.this.rootPath.resolve(this.relativePath);
        }

        public URL getFullPathAsUrl() throws MalformedURLException {
            URI fullPath = this.getFullPath();
            return "classpath".equals(fullPath.getScheme()) ? this.getClass().getResource(fullPath.getPath()) : fullPath.toURL();
        }

        public LoadedEntityScopes withScopes(List<Object> scopes, Path relativeOutputFilename) {
            return new LoadedEntityScopes(this.relativePath, scopes, relativeOutputFilename);
        }
    }
}

