/*
 * Decompiled with CFR 0.152.
 */
package net.zscript.maven.templating.contextloader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.zscript.maven.templating.contextloader.LoadableEntities;
import net.zscript.maven.templating.contextloader.TemplatingPluginContextLoader;
import org.yaml.snakeyaml.Yaml;

public class YamlTemplatingPluginContextLoader
implements TemplatingPluginContextLoader {
    private final Yaml yamlMapper = new Yaml();

    @Override
    public List<LoadableEntities.LoadedEntityScopes> loadAndMap(LoadableEntities entities) {
        return entities.loadEntities(this::load);
    }

    private List<LoadableEntities.LoadedEntityScopes> load(LoadableEntities.LoadableEntity entity) {
        List<LoadableEntities.LoadedEntityScopes> list;
        String relativePathToSource = entity.getRelativePath();
        int dotIndex = relativePathToSource.lastIndexOf(46);
        String newUriPath = (dotIndex != -1 ? relativePathToSource.substring(0, dotIndex) : relativePathToSource) + "." + entity.getFileTypeSuffix();
        Path relativePathToOutput = entity.getFileSystem().getPath(newUriPath, new String[0]);
        BufferedReader r = new BufferedReader(new InputStreamReader(entity.getFullPathAsUrl().openStream(), StandardCharsets.UTF_8));
        try {
            Map value = (Map)this.yamlMapper.load((Reader)r);
            list = Collections.singletonList(entity.withScopes(Collections.singletonList(value), relativePathToOutput));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NullPointerException ex) {
                throw new UncheckedIOException(new IOException("Failed to read from: " + entity.getFullPath(), ex));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        ((Reader)r).close();
        return list;
    }
}

