/*
 * Decompiled with CFR 0.152.
 */
package net.zscript.maven.templating.plugin;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheResolver;
import com.github.mustachejava.resolver.ClasspathResolver;
import com.github.mustachejava.resolver.DefaultResolver;
import com.github.mustachejava.resolver.FileSystemResolver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.zscript.maven.templating.contextloader.LoadableEntities;
import net.zscript.maven.templating.contextloader.TemplatingPluginContextLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

abstract class TemplatingBaseMojo
extends AbstractMojo {
    private static final String FILE_TYPE_SUFFIX_DEFAULT = "java";
    private static final FileSystem FS = FileSystems.getDefault();
    @Parameter
    protected String templateDirectory;
    @Parameter(required=true)
    protected String mainTemplate;
    @Parameter
    protected FileSet contexts;
    @Parameter
    protected File outputDirectory;
    @Parameter(defaultValue="net.zscript.maven.templating.contextloader.YamlTemplatingPluginContextLoader")
    protected String contextLoaderClass;
    @Parameter(defaultValue="true")
    protected boolean failIfNoFiles;
    @Parameter(defaultValue="java")
    protected String fileTypeSuffix;
    @Parameter
    protected String generateSources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    protected final List<String> templateRootDirs = new ArrayList<String>();

    TemplatingBaseMojo() {
    }

    public String executeBase(String contextDefaultDir, String outputDefaultDir) throws MojoExecutionException {
        MustacheResolver mustacheResolver = this.createMustacheResolver();
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory(mustacheResolver);
        FileSet contextFileSet = this.initFileSet(this.contexts, contextDefaultDir);
        LoadableEntities contextEntities = this.extractContextFileList(contextFileSet);
        List<LoadableEntities.LoadedEntityScopes> loadedMappedScopes = this.loadMappedContexts(contextEntities);
        this.getLog().info((CharSequence)("outputDir: " + this.outputDirectory));
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.project.getBuild().getDirectory(), outputDefaultDir);
        }
        this.getLog().info((CharSequence)("outputDir: " + this.outputDirectory));
        Path outputDirectoryPath = this.outputDirectory.toPath();
        this.createDirIfRequired(outputDirectoryPath);
        for (LoadableEntities.LoadedEntityScopes context : loadedMappedScopes) {
            try {
                Path outputFileFullPath = outputDirectoryPath.resolve(context.getRelativeOutputPath());
                Path outputParentDir = outputFileFullPath.getParent();
                this.createDirIfRequired(outputParentDir);
                Mustache mustache = mustacheFactory.compile(this.mainTemplate);
                this.getLog().info((CharSequence)("Applying context " + context.getRelativePath() + " with template " + this.mainTemplate + " to " + outputFileFullPath));
                BufferedWriter out = Files.newBufferedWriter(outputFileFullPath, new OpenOption[0]);
                try {
                    mustache.execute((Writer)out, context.getScopes());
                }
                finally {
                    if (out == null) continue;
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to generate output file: " + outputDirectoryPath, (Exception)e);
            }
        }
        if (Boolean.parseBoolean(this.generateSources) || this.generateSources == null && this.fileTypeSuffix.equals(FILE_TYPE_SUFFIX_DEFAULT)) {
            return outputDirectoryPath.toString();
        }
        return null;
    }

    private MustacheResolver createMustacheResolver() {
        String messagePrefix = "Main Template resolution for \"" + this.mainTemplate + "\": ";
        MustacheResolver mustacheResolver = null;
        try {
            if (this.templateDirectory == null || this.templateDirectory.isEmpty() || new File(this.templateDirectory).isAbsolute() || new URI(this.templateDirectory).getScheme() == null) {
                if (this.templateDirectory != null && !this.templateDirectory.isEmpty()) {
                    mustacheResolver = this.createFileResolver(FS.getPath(this.templateDirectory, new String[0]));
                }
                if (mustacheResolver == null) {
                    for (String defaultDir : this.templateRootDirs) {
                        Path resolvedDir = this.project.getBasedir().toPath().resolve(defaultDir);
                        mustacheResolver = this.createFileResolver(resolvedDir);
                        if (mustacheResolver == null) continue;
                        break;
                    }
                }
                if (mustacheResolver == null) {
                    throw new TemplatingMojoFailureException("Cannot locate template: " + this.mainTemplate);
                }
                return mustacheResolver;
            }
            URI dirUri = new URI(this.templateDirectory);
            if (dirUri.getScheme().equals("classpath")) {
                String path = dirUri.getPath();
                String resourceRoot = path.startsWith("/") ? path.substring(1) : path;
                this.getLog().debug((CharSequence)(messagePrefix + ": use ClasspathResolver with resourceRoot: " + resourceRoot));
                return new ClasspathResolver(resourceRoot);
            }
            this.getLog().debug((CharSequence)(messagePrefix + ": use DefaultResolver with resourceRoot: " + dirUri.getPath()));
            return new DefaultResolver(dirUri.getPath());
        }
        catch (URISyntaxException e1) {
            throw new TemplatingMojoFailureException("Bad URI: " + this.mainTemplate, e1);
        }
    }

    private MustacheResolver createFileResolver(Path templateRootCandidate) {
        Path resolvedTemplateDir;
        if (!Files.isDirectory(templateRootCandidate, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("  checked possible base dir (doesn't exist): " + templateRootCandidate));
            return null;
        }
        Path path = resolvedTemplateDir = this.templateDirectory == null ? templateRootCandidate : templateRootCandidate.resolve(this.templateDirectory);
        if (!Files.isDirectory(resolvedTemplateDir, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("  checked possible template root dir (doesn't exist): " + templateRootCandidate));
            return null;
        }
        Path mainTemplateFullPath = templateRootCandidate.resolve(this.mainTemplate);
        if (!Files.isRegularFile(mainTemplateFullPath, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("  possible template root dir exists: " + templateRootCandidate));
            this.getLog().debug((CharSequence)("  but template doesn't: " + mainTemplateFullPath));
            return null;
        }
        this.getLog().info((CharSequence)("Template found in dir: " + templateRootCandidate));
        return new FileSystemResolver(resolvedTemplateDir.toFile());
    }

    private void createDirIfRequired(Path outputDirectoryPath) throws MojoExecutionException {
        if (!Files.isDirectory(outputDirectoryPath, new LinkOption[0])) {
            try {
                this.getLog().debug((CharSequence)("Creating output directory: " + outputDirectoryPath));
                Files.createDirectories(outputDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create output directory: " + outputDirectoryPath, (Exception)e);
            }
        }
    }

    private FileSet initFileSet(FileSet fs, String defaultDir) {
        FileSet fileSet;
        FileSet fileSet2 = fileSet = fs != null ? fs : new FileSet();
        if (fileSet.getDirectory() == null) {
            Path dirToSet = this.project.getBasedir().toPath().resolve(defaultDir);
            fileSet.setDirectory(dirToSet.toString());
        }
        return fileSet;
    }

    private LoadableEntities extractContextFileList(FileSet fileSet) throws MojoExecutionException {
        String directoryString = fileSet.getDirectory();
        try {
            URI rootUri = new URI(directoryString);
            if (rootUri.getScheme() != null) {
                this.getLog().debug((CharSequence)("Context: directory is valid URI, so assuming using limited 'includes' paths: " + directoryString));
                return new LoadableEntities(rootUri, fileSet.getIncludes(), this.fileTypeSuffix, FS);
            }
        }
        catch (URISyntaxException e) {
            this.getLog().debug((CharSequence)("Context: directory isn't valid URI, so assuming local directory: " + directoryString));
        }
        return this.extractFileListAsLocalFiles(fileSet, FS.getPath(directoryString, new String[0]));
    }

    private LoadableEntities extractFileListAsLocalFiles(FileSet fileSet, Path rootPath) throws MojoExecutionException {
        if (!Files.isDirectory(rootPath, new LinkOption[0])) {
            throw new MojoExecutionException("Context directory not found: " + rootPath);
        }
        if (!Files.isReadable(rootPath)) {
            throw new MojoExecutionException("Context directory not readable: " + rootPath);
        }
        URI rootUri = rootPath.toUri();
        this.getLog().debug((CharSequence)("    Context: fileSet.getDirectory: " + rootPath + "; rootUri: " + rootUri));
        FileSetManager fileSetManager = new FileSetManager();
        List<String> files = Arrays.stream(fileSetManager.getIncludedFiles(fileSet)).collect(Collectors.toList());
        if (this.failIfNoFiles && files.isEmpty()) {
            throw new MojoExecutionException("No matching Context files found in: " + rootPath);
        }
        this.getLog().debug((CharSequence)("    #files = " + files.size()));
        files.forEach(f -> this.getLog().debug((CharSequence)("    " + f)));
        return new LoadableEntities(rootUri, files, this.fileTypeSuffix, rootPath.getFileSystem());
    }

    private List<LoadableEntities.LoadedEntityScopes> loadMappedContexts(LoadableEntities contextEntities) throws MojoExecutionException {
        TemplatingPluginContextLoader contextLoader;
        try {
            contextLoader = (TemplatingPluginContextLoader)Class.forName(this.contextLoaderClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot load class '" + this.contextLoaderClass + "'", e);
        }
        return contextLoader.loadAndMap(contextEntities);
    }

    static class TemplatingMojoFailureException
    extends RuntimeException {
        TemplatingMojoFailureException(String msg, Exception e) {
            super(msg, e);
        }

        TemplatingMojoFailureException(String msg) {
            super(msg);
        }
    }
}

