package multiplatform.network.cmptoast

import android.content.Context
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.unit.TextUnit
import java.lang.ref.WeakReference

actual object AppContext {
    private var value: WeakReference<Context?>? = null
    fun set(context: Context) {
        value = WeakReference(context)
    }
    internal fun get(): Context {
        return value?.get() ?: throw RuntimeException("Context Error")
    }
}

actual fun showToast(
    message: String,
    gravity: ToastGravity,
    backgroundColor: Color,
    textColor: Color,
    duration: ToastDuration,
    padding: ToastPadding?,
    textSize: TextUnit,
    topPadding: Int,
    bottomPadding: Int,
    cornerRadius: Int?,
    icon: ImageBitmap?,
    iconSizeDp: Int
) {
    toast(
        context = AppContext.get(),
        message = message,
        gravity = gravity,
        backgroundColor = backgroundColor,
        textColor = textColor,
        duration = duration,
        textSize = textSize,
        padding = padding,
        topPadding = topPadding,
        bottomPadding = bottomPadding,
        cornerRadius = cornerRadius,
        icon = icon,
        iconSizeDp = iconSizeDp
    )
}