package multiplatform.network.cmptoast

import androidx.compose.runtime.State
import androidx.compose.runtime.mutableStateOf
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.unit.Density
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.TextUnit

data class ToastData(
    val message: String,
    val gravity: ToastGravity,
    val backgroundColor: Color,
    val textColor: Color,
    val duration: ToastDuration,
    val padding: ToastPadding?,
    val textSize: TextUnit,
    val topPadding: Int,
    val bottomPadding: Int,
    val cornerRadius: Int?,
    val icon: ImageBitmap?,
    val iconSizeDp: Int
)

object ToastManager {
    private var _currentToast = mutableStateOf<ToastData?>(null)
    val currentToast: State<ToastData?> = _currentToast

    fun showToast(toastData: ToastData) {
        _currentToast.value = toastData
    }

    fun dismissToast() {
        _currentToast.value = null
    }
}

fun Dp.toPx(density: Density): Int = with(density) { this@toPx.roundToPx() }
