package multiplatform.network.cmptoast

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.sp

expect object AppContext

expect fun showToast(
    message: String,
    gravity: ToastGravity = ToastGravity.Bottom,
    backgroundColor: Color = Color.Black,
    textColor: Color = Color.White,
    duration: ToastDuration = ToastDuration.Short,
    padding: ToastPadding? = null,
    textSize: TextUnit = 14.sp,
    topPadding: Int = 0,
    bottomPadding: Int = 0,
    cornerRadius: Int? = null
)

sealed class ToastGravity {
    data object Top : ToastGravity()
    data object Bottom : ToastGravity()
    data object Center : ToastGravity()
}

sealed class ToastDuration {
    data object Long : ToastDuration()
    data object Short : ToastDuration()
}

data class ToastPadding (
    var top: Int = 10,
    var bottom: Int = 10,
    var left: Int = 10,
    var right: Int = 10
)