package multiplatform.network.cmptoast

import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.graphics.asSkiaBitmap
import kotlinx.cinterop.*
import platform.Foundation.*
import platform.UIKit.*
import org.jetbrains.skia.Image
import org.jetbrains.skia.EncodedImageFormat


/**
 * Helper function to create UIImage directly from ImageBitmap
 * This can be used as an alternative to the CGImage approach
 */
@OptIn(ExperimentalForeignApi::class)
fun ImageBitmap.toUIImage(): UIImage {
    val skiaBitmap = this.asSkiaBitmap()
    val skiaImage = Image.makeFromBitmap(skiaBitmap)
    val encodedData = skiaImage.encodeToData(EncodedImageFormat.PNG)
        ?: error("Failed to encode image to PNG")
    
    val nsData = encodedData.bytes.usePinned { pinned ->
        NSData.create(
            bytes = pinned.addressOf(0),
            length = encodedData.size.toULong()
        )
    }
    
    return UIImage.imageWithData(nsData)
        ?: error("Failed to create UIImage from data")
}