package multiplatform.network.cmptoast

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.unit.TextUnit

actual object AppContext

actual fun showToast(
    message: String,
    gravity: ToastGravity,
    backgroundColor: Color,
    textColor: Color,
    duration: ToastDuration,
    padding: ToastPadding?,
    textSize: TextUnit,
    topPadding: Int,
    bottomPadding: Int,
    cornerRadius: Int?,
    icon: ImageBitmap?,
    iconSizeDp: Int
) {
    val toastData = ToastData(
        message = message,
        gravity = gravity,
        backgroundColor = backgroundColor,
        textColor = textColor,
        duration = duration,
        padding = padding,
        textSize = textSize,
        topPadding = topPadding,
        bottomPadding = bottomPadding,
        cornerRadius = cornerRadius,
        icon = icon,
        iconSizeDp = iconSizeDp
    )

    ToastManager.showToast(toastData)
}