package network.chaintech.ui.datetimepicker

import kotlinx.datetime.LocalDate
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.LocalTime


internal sealed class SnappedDate(val snappedLocalDate: LocalDate) {
    data class DayOfMonth(val localDate: LocalDate, val index: Int) :
        SnappedDate(localDate)

    data class Month(val localDate: LocalDate, val index: Int) : SnappedDate(localDate)
    data class Year(val localDate: LocalDate, val index: Int) : SnappedDate(localDate)
}


sealed class SnappedDateTime(
    val snappedLocalDateTime: LocalDateTime,
    val snappedIndex: Int
) {
    data class DayOfMonth(val localDateTime: LocalDateTime, val index: Int) :
        SnappedDateTime(localDateTime, index)

    data class Month(val localDateTime: LocalDateTime, val index: Int) :
        SnappedDateTime(localDateTime, index)

    data class Year(val localDateTime: LocalDateTime, val index: Int) :
        SnappedDateTime(localDateTime, index)

    data class Hour(val localDateTime: LocalDateTime, val index: Int) :
        SnappedDateTime(localDateTime, index)

    data class Minute(val localDateTime: LocalDateTime, val index: Int) :
        SnappedDateTime(localDateTime, index)
}

internal sealed class SnappedTime(val snappedLocalTime: LocalTime) {
    data class Hour(val localTime: LocalTime, val index: Int) : SnappedTime(localTime)
    data class Minute(val localTime: LocalTime, val index: Int) : SnappedTime(localTime)
}