/*
 * Decompiled with CFR 0.152.
 */
package network.chaintech.kmp_date_time_picker;

import androidx.annotation.RequiresApi;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a8\u0006\f"}, d2={"format", "", "localDateTime", "Lkotlinx/datetime/LocalDateTime;", "outputFormat", "parse", "strDateTime", "dateFormat", "localTime", "Lkotlinx/datetime/LocalTime;", "localDate", "Lkotlinx/datetime/LocalDate;", "kmp-date-time-picker_release"})
public final class DateTimeUtils_androidKt {
    @RequiresApi(value=26)
    @NotNull
    public static final String format(@NotNull kotlinx.datetime.LocalDateTime localDateTime, @NotNull String outputFormat) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        String str = DateTimeFormatter.ofPattern(outputFormat, Locale.getDefault()).format(ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)localDateTime));
        Intrinsics.checkNotNull((Object)str);
        return str;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final kotlinx.datetime.LocalDateTime parse(@NotNull String strDateTime, @NotNull String dateFormat) {
        Intrinsics.checkNotNullParameter((Object)strDateTime, (String)"strDateTime");
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat, Locale.getDefault());
        LocalDateTime localDateTime = LocalDateTime.parse(strDateTime, formatter);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
        return ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
    }

    @RequiresApi(value=26)
    @NotNull
    public static final String format(@NotNull LocalTime localTime, @NotNull String outputFormat) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        String str = DateTimeFormatter.ofPattern(outputFormat, Locale.getDefault()).format(ConvertersKt.toJavaLocalTime((LocalTime)localTime));
        Intrinsics.checkNotNull((Object)str);
        return str;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final String format(@NotNull LocalDate localDate, @NotNull String outputFormat) {
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        String str = DateTimeFormatter.ofPattern(outputFormat, Locale.getDefault()).format(ConvertersKt.toJavaLocalDate((LocalDate)localDate));
        Intrinsics.checkNotNull((Object)str);
        return str;
    }
}

