/*
 * Decompiled with CFR 0.152.
 */
package network.chaintech.kmp_date_time_picker.ui.datetimepicker;

import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import network.chaintech.kmp_date_time_picker.ui.datetimepicker.ExperimentalSnapperApi;
import network.chaintech.kmp_date_time_picker.ui.datetimepicker.LazyListSnapperLayoutInfo;
import network.chaintech.kmp_date_time_picker.ui.datetimepicker.SnapperLayoutInfo;
import network.chaintech.kmp_date_time_picker.ui.datetimepicker.SnapperLayoutItemInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J&\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)2\u0006\u0010*\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/LazyListSnapperLayoutInfo;", "Lnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/SnapperLayoutInfo;", "lazyListState", "Landroidx/compose/foundation/lazy/LazyListState;", "snapOffsetForItem", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "layoutInfo", "Lnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/SnapperLayoutItemInfo;", "item", "", "<init>", "(Landroidx/compose/foundation/lazy/LazyListState;Lkotlin/jvm/functions/Function2;)V", "startScrollOffset", "getStartScrollOffset", "()I", "endScrollOffset", "getEndScrollOffset", "itemCount", "getItemCount", "totalItemsCount", "getTotalItemsCount", "currentItem", "getCurrentItem", "()Lnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/SnapperLayoutItemInfo;", "currentItem$delegate", "Landroidx/compose/runtime/State;", "visibleItems", "Lkotlin/sequences/Sequence;", "getVisibleItems", "()Lkotlin/sequences/Sequence;", "distanceToIndexSnap", "index", "canScrollTowardsStart", "", "canScrollTowardsEnd", "determineTargetIndex", "velocity", "", "decayAnimationSpec", "Landroidx/compose/animation/core/DecayAnimationSpec;", "maximumFlingDistance", "calculateItemSpacing", "estimateDistancePerItem", "kmp-date-time-picker_release"})
@ExperimentalSnapperApi
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nSnapperFlingBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapperFlingBehavior.kt\nnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/LazyListSnapperLayoutInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n1#2:560\n81#3:561\n183#4,2:562\n320#4,7:592\n2341#5,14:564\n1971#5,14:578\n*S KotlinDebug\n*F\n+ 1 SnapperFlingBehavior.kt\nnetwork/chaintech/kmp_date_time_picker/ui/datetimepicker/LazyListSnapperLayoutInfo\n*L\n112#1:561\n121#1:562,2\n113#1:592,7\n195#1:564,14\n196#1:578,14\n*E\n"})
public final class LazyListSnapperLayoutInfo
extends SnapperLayoutInfo {
    @NotNull
    private final LazyListState lazyListState;
    @NotNull
    private final Function2<SnapperLayoutInfo, SnapperLayoutItemInfo, Integer> snapOffsetForItem;
    private final int startScrollOffset;
    @NotNull
    private final State currentItem$delegate;
    public static final int $stable;

    public LazyListSnapperLayoutInfo(@NotNull LazyListState lazyListState, @NotNull Function2<? super SnapperLayoutInfo, ? super SnapperLayoutItemInfo, Integer> snapOffsetForItem) {
        Intrinsics.checkNotNullParameter((Object)lazyListState, (String)"lazyListState");
        Intrinsics.checkNotNullParameter(snapOffsetForItem, (String)"snapOffsetForItem");
        this.lazyListState = lazyListState;
        this.snapOffsetForItem = snapOffsetForItem;
        this.currentItem$delegate = SnapshotStateKt.derivedStateOf(() -> LazyListSnapperLayoutInfo.currentItem_delegate$lambda$2(this));
    }

    @Override
    public int getStartScrollOffset() {
        return this.startScrollOffset;
    }

    @Override
    public int getEndScrollOffset() {
        LazyListLayoutInfo it = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        return it.getViewportEndOffset() - it.getAfterContentPadding();
    }

    private final int getItemCount() {
        return this.lazyListState.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    public int getTotalItemsCount() {
        return this.lazyListState.getLayoutInfo().getTotalItemsCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public SnapperLayoutItemInfo getCurrentItem() {
        void $this$getValue$iv;
        State state = this.currentItem$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (SnapperLayoutItemInfo)$this$getValue$iv.getValue();
    }

    @Override
    @NotNull
    public Sequence<SnapperLayoutItemInfo> getVisibleItems() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.lazyListState.getLayoutInfo().getVisibleItemsInfo()), (Function1)visibleItems.1.INSTANCE);
    }

    @Override
    public int distanceToIndexSnap(int index) {
        Object v0;
        block3: {
            Sequence<SnapperLayoutItemInfo> $this$firstOrNull$iv = this.getVisibleItems();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SnapperLayoutItemInfo it = (SnapperLayoutItemInfo)element$iv;
                boolean bl = false;
                if (!(it.getIndex() == index)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        SnapperLayoutItemInfo itemInfo = v0;
        if (itemInfo != null) {
            return itemInfo.getOffset() - ((Number)this.snapOffsetForItem.invoke((Object)this, (Object)itemInfo)).intValue();
        }
        SnapperLayoutItemInfo snapperLayoutItemInfo = this.getCurrentItem();
        if (snapperLayoutItemInfo == null) {
            return 0;
        }
        SnapperLayoutItemInfo currentItem = snapperLayoutItemInfo;
        return MathKt.roundToInt((float)((float)(index - currentItem.getIndex()) * this.estimateDistancePerItem())) + currentItem.getOffset() - ((Number)this.snapOffsetForItem.invoke((Object)this, (Object)currentItem)).intValue();
    }

    @Override
    public boolean canScrollTowardsStart() {
        boolean bl;
        LazyListItemInfo lazyListItemInfo = (LazyListItemInfo)CollectionsKt.firstOrNull((List)this.lazyListState.getLayoutInfo().getVisibleItemsInfo());
        if (lazyListItemInfo != null) {
            LazyListItemInfo it = lazyListItemInfo;
            boolean bl2 = false;
            bl = it.getIndex() > 0 || it.getOffset() < this.getStartScrollOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canScrollTowardsEnd() {
        boolean bl;
        LazyListItemInfo lazyListItemInfo = (LazyListItemInfo)CollectionsKt.lastOrNull((List)this.lazyListState.getLayoutInfo().getVisibleItemsInfo());
        if (lazyListItemInfo != null) {
            LazyListItemInfo it = lazyListItemInfo;
            boolean bl2 = false;
            bl = it.getIndex() < this.getItemCount() - 1 || it.getOffset() + it.getSize() > this.getEndScrollOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int determineTargetIndex(float velocity, @NotNull DecayAnimationSpec<Float> decayAnimationSpec, float maximumFlingDistance) {
        Intrinsics.checkNotNullParameter(decayAnimationSpec, (String)"decayAnimationSpec");
        SnapperLayoutItemInfo snapperLayoutItemInfo = this.getCurrentItem();
        if (snapperLayoutItemInfo == null) {
            return -1;
        }
        SnapperLayoutItemInfo curr = snapperLayoutItemInfo;
        float distancePerItem = this.estimateDistancePerItem();
        if (distancePerItem <= 0.0f) {
            return curr.getIndex();
        }
        int distanceToCurrent = this.distanceToIndexSnap(curr.getIndex());
        int distanceToNext = this.distanceToIndexSnap(curr.getIndex() + 1);
        if (Math.abs(velocity) < 0.5f) {
            return RangesKt.coerceIn((int)(Math.abs(distanceToCurrent) < Math.abs(distanceToNext) ? curr.getIndex() : curr.getIndex() + 1), (int)0, (int)(this.getItemCount() - 1));
        }
        float distance = RangesKt.coerceIn((float)DecayAnimationSpecKt.calculateTargetValue(decayAnimationSpec, (float)0.0f, (float)velocity), (float)(-maximumFlingDistance), (float)maximumFlingDistance);
        boolean bl = false;
        float flingDistance = velocity < 0.0f ? RangesKt.coerceAtMost((float)(distance + (float)distanceToNext), (float)0.0f) : RangesKt.coerceAtLeast((float)(distance + (float)distanceToCurrent), (float)0.0f);
        double flingIndexDelta = (double)flingDistance / (double)distancePerItem;
        double currentItemOffsetRatio = (double)distanceToCurrent / (double)distancePerItem;
        int indexOffset = MathKt.roundToInt((double)(flingIndexDelta - currentItemOffsetRatio));
        return RangesKt.coerceIn((int)(curr.getIndex() + indexOffset), (int)0, (int)(this.getItemCount() - 1));
    }

    private final int calculateItemSpacing() {
        int n;
        LazyListLayoutInfo $this$calculateItemSpacing_u24lambda_u247 = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        if ($this$calculateItemSpacing_u24lambda_u247.getVisibleItemsInfo().size() >= 2) {
            LazyListItemInfo first = (LazyListItemInfo)$this$calculateItemSpacing_u24lambda_u247.getVisibleItemsInfo().get(0);
            LazyListItemInfo second = (LazyListItemInfo)$this$calculateItemSpacing_u24lambda_u247.getVisibleItemsInfo().get(1);
            n = second.getOffset() - (first.getSize() + first.getOffset());
        } else {
            n = 0;
        }
        return n;
    }

    private final float estimateDistancePerItem() {
        Object v2;
        Object v0;
        LazyListLayoutInfo $this$estimateDistancePerItem_u24lambda_u2410 = this.lazyListState.getLayoutInfo();
        boolean bl = false;
        if ($this$estimateDistancePerItem_u24lambda_u2410.getVisibleItemsInfo().isEmpty()) {
            return -1.0f;
        }
        Iterable $this$minByOrNull$iv = $this$estimateDistancePerItem_u24lambda_u2410.getVisibleItemsInfo();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LazyListItemInfo it = (LazyListItemInfo)minElem$iv;
                boolean bl2 = false;
                int minValue$iv = it.getOffset();
                do {
                    Object e$iv = iterator$iv.next();
                    LazyListItemInfo it2 = (LazyListItemInfo)e$iv;
                    $i$a$-minByOrNull-LazyListSnapperLayoutInfo$estimateDistancePerItem$1$minPosView$1 = false;
                    int v$iv = it2.getOffset();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        LazyListItemInfo lazyListItemInfo = v0;
        if (lazyListItemInfo == null) {
            return -1.0f;
        }
        LazyListItemInfo minPosView = lazyListItemInfo;
        Iterable $this$maxByOrNull$iv = $this$estimateDistancePerItem_u24lambda_u2410.getVisibleItemsInfo();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = maxElem$iv;
            } else {
                LazyListItemInfo it = (LazyListItemInfo)maxElem$iv;
                boolean bl3 = false;
                int maxValue$iv = it.getOffset() + it.getSize();
                do {
                    Object e$iv = iterator$iv2.next();
                    LazyListItemInfo it3 = (LazyListItemInfo)e$iv;
                    $i$a$-maxByOrNull-LazyListSnapperLayoutInfo$estimateDistancePerItem$1$maxPosView$1 = false;
                    int v$iv = it3.getOffset() + it3.getSize();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = maxElem$iv;
            }
        }
        LazyListItemInfo lazyListItemInfo2 = v2;
        if (lazyListItemInfo2 == null) {
            return -1.0f;
        }
        LazyListItemInfo maxPosView = lazyListItemInfo2;
        int start = Math.min(minPosView.getOffset(), maxPosView.getOffset());
        int end = Math.max(minPosView.getOffset() + minPosView.getSize(), maxPosView.getOffset() + maxPosView.getSize());
        int distance = end - start;
        return distance == 0 ? -1.0f : (float)(distance + this.calculateItemSpacing()) / (float)$this$estimateDistancePerItem_u24lambda_u2410.getVisibleItemsInfo().size();
    }

    /*
     * WARNING - void declaration
     */
    private static final SnapperLayoutItemInfo currentItem_delegate$lambda$2(LazyListSnapperLayoutInfo this$0) {
        void var3_3;
        Sequence<SnapperLayoutItemInfo> $this$lastOrNull$iv = this$0.getVisibleItems();
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            SnapperLayoutItemInfo it = (SnapperLayoutItemInfo)element$iv;
            boolean bl = false;
            if (!(it.getOffset() <= ((Number)this$0.snapOffsetForItem.invoke((Object)this$0, (Object)it)).intValue())) continue;
            last$iv = element$iv;
        }
        return (SnapperLayoutItemInfo)var3_3;
    }
}

