/*
 * Decompiled with CFR 0.152.
 */
package network.chaintech.kmp_date_time_picker.utils;

import androidx.compose.foundation.ClickableKt;
import androidx.compose.foundation.interaction.InteractionSourceKt;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.ui.ComposedModifierKt;
import androidx.compose.ui.Modifier;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import network.chaintech.kmp_date_time_picker.DateTimeUtils_androidKt;
import network.chaintech.kmp_date_time_picker.utils.AmPmValue;
import network.chaintech.kmp_date_time_picker.utils.DayOfMonth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0000\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000b\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000b\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b\u001a\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000b\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000b\u001a\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0017\u001a\u0012\u0010\u0019\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b\u001a\n\u0010!\u001a\u00020\u0017*\u00020\u0003\u001a\n\u0010\"\u001a\u00020\u0017*\u00020\u0003\u001a\u0014\u0010#\u001a\u00020\u0017*\u00020\u00032\b\b\u0002\u0010$\u001a\u00020\u0017\u001a\f\u0010%\u001a\u00020\u0017*\u00020\u0017H\u0002\u001a\u0012\u0010&\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0006\u0010'\u001a\u00020\u0003\u001a\u0014\u0010(\u001a\u00020\u0003*\u00020\u00032\u0006\u0010)\u001a\u00020\u000bH\u0002\u001a\u0018\u0010*\u001a\u00020+*\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-\u001a\u0016\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0017\u001a\u0016\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0017\u001a\u001c\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b\u001a\u000e\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u0005\u001a\u001e\u00109\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005\u001a\u001e\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@\u001a\u000e\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020\u0005\"\u000e\u0010\u001e\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"now", "Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/LocalDateTime$Companion;", "Lkotlinx/datetime/LocalDate;", "Lkotlinx/datetime/LocalDate$Companion;", "Lkotlinx/datetime/LocalTime;", "Lkotlinx/datetime/LocalTime$Companion;", "MIN", "MAX", "withDayOfMonth", "dayOfMonth", "", "withMonth", "month", "withYear", "year", "withHour", "hour", "withMinute", "minute", "isLeapYear", "", "shortMonths", "", "capitalize", "truncateTo", "unit", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "shortDayOfWeek", "dayOfWeek", "ISO8601", "MONTH_YEAR", "SHORT_DAY", "toMonthYear", "toShortDay", "asString", "format", "firstLetterUppercase", "monthLength", "getFirstDayOfWeek", "daysShift", "days", "noRippleEffect", "Landroidx/compose/ui/Modifier;", "onClick", "Lkotlin/Function0;", "", "dateTimeToString", "currentDateTime", "givenFormat", "timeToString", "currentTime", "calculateDayOfMonths", "", "Lnetwork/chaintech/kmp_date_time_picker/utils/DayOfMonth;", "localTimeToAmPmHour", "localTime", "isBetween", "startTime", "endTime", "amPmHourToHour24", "amPmHour", "amPmMinute", "amPmValue", "Lnetwork/chaintech/kmp_date_time_picker/utils/AmPmValue;", "amPmValueFromTime", "time", "kmp-date-time-picker_release"})
@SourceDebugExtension(value={"SMAP\nDateCommonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateCommonUtils.kt\nnetwork/chaintech/kmp_date_time_picker/utils/DateCommonUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1#2:477\n1557#3:478\n1628#3,3:479\n1557#3:482\n1628#3,3:483\n1557#3:486\n1628#3,3:487\n1557#3:490\n1628#3,3:491\n*S KotlinDebug\n*F\n+ 1 DateCommonUtils.kt\nnetwork/chaintech/kmp_date_time_picker/utils/DateCommonUtilsKt\n*L\n271#1:478\n271#1:479,3\n278#1:482\n278#1:483,3\n285#1:486\n285#1:487,3\n292#1:490\n292#1:491,3\n*E\n"})
public final class DateCommonUtilsKt {
    @NotNull
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @NotNull
    public static final String MONTH_YEAR = "MMMM YYYY";
    @NotNull
    public static final String SHORT_DAY = "EEE";

    @NotNull
    public static final LocalDateTime now(@NotNull LocalDateTime.Companion $this$now) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault());
    }

    @NotNull
    public static final LocalDate now(@NotNull LocalDate.Companion $this$now) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        return DateCommonUtilsKt.now(LocalDateTime.Companion).getDate();
    }

    @NotNull
    public static final LocalTime now(@NotNull LocalTime.Companion $this$now) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        return DateCommonUtilsKt.now(LocalDateTime.Companion).getTime();
    }

    @NotNull
    public static final LocalTime MIN(@NotNull LocalTime.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return new LocalTime(0, 0, 0, 0, 12, null);
    }

    @NotNull
    public static final LocalTime MAX(@NotNull LocalTime.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return new LocalTime(23, 59, 59, 999999999);
    }

    @NotNull
    public static final LocalDateTime MIN(@NotNull LocalDateTime.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return new LocalDateTime(1900, 1, 1, 0, 0, 0, 0);
    }

    @NotNull
    public static final LocalDateTime MAX(@NotNull LocalDateTime.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return new LocalDateTime(DateCommonUtilsKt.now(LocalDateTime.Companion).getYear() + 10, 12, 31, 0, 0, 0, 0);
    }

    @NotNull
    public static final LocalDate MIN(@NotNull LocalDate.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return new LocalDate(1900, 1, 1);
    }

    @NotNull
    public static final LocalDate MAX(@NotNull LocalDate.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return new LocalDate(DateCommonUtilsKt.now(LocalDateTime.Companion).getYear() + 100, 12, 31);
    }

    @NotNull
    public static final LocalDate withDayOfMonth(@NotNull LocalDate $this$withDayOfMonth, int dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOfMonth, (String)"<this>");
        return new LocalDate($this$withDayOfMonth.getYear(), $this$withDayOfMonth.getMonth(), dayOfMonth);
    }

    @NotNull
    public static final LocalDate withMonth(@NotNull LocalDate $this$withMonth, int month) {
        Intrinsics.checkNotNullParameter((Object)$this$withMonth, (String)"<this>");
        int length = DateCommonUtilsKt.monthLength(month, DateCommonUtilsKt.isLeapYear($this$withMonth.getYear()));
        return $this$withMonth.getDayOfMonth() > length ? new LocalDate($this$withMonth.getYear(), month, length) : new LocalDate($this$withMonth.getYear(), month, $this$withMonth.getDayOfMonth());
    }

    @NotNull
    public static final LocalDate withYear(@NotNull LocalDate $this$withYear, int year) {
        Intrinsics.checkNotNullParameter((Object)$this$withYear, (String)"<this>");
        return new LocalDate(year, $this$withYear.getMonth(), $this$withYear.getDayOfMonth());
    }

    @NotNull
    public static final LocalDateTime withDayOfMonth(@NotNull LocalDateTime $this$withDayOfMonth, int dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOfMonth, (String)"<this>");
        return new LocalDateTime($this$withDayOfMonth.getYear(), $this$withDayOfMonth.getMonth(), dayOfMonth, $this$withDayOfMonth.getHour(), $this$withDayOfMonth.getMinute(), $this$withDayOfMonth.getSecond(), 0, 64, null);
    }

    @NotNull
    public static final LocalDateTime withMonth(@NotNull LocalDateTime $this$withMonth, int month) {
        Intrinsics.checkNotNullParameter((Object)$this$withMonth, (String)"<this>");
        int length = DateCommonUtilsKt.monthLength(month, DateCommonUtilsKt.isLeapYear($this$withMonth.getYear()));
        return $this$withMonth.getDayOfMonth() > length ? new LocalDateTime($this$withMonth.getYear(), month, length, $this$withMonth.getHour(), $this$withMonth.getMinute(), $this$withMonth.getSecond(), 0, 64, null) : new LocalDateTime($this$withMonth.getYear(), month, $this$withMonth.getDayOfMonth(), $this$withMonth.getHour(), $this$withMonth.getMinute(), $this$withMonth.getSecond(), 0, 64, null);
    }

    @NotNull
    public static final LocalDateTime withYear(@NotNull LocalDateTime $this$withYear, int year) {
        Intrinsics.checkNotNullParameter((Object)$this$withYear, (String)"<this>");
        return new LocalDateTime(year, $this$withYear.getMonth(), $this$withYear.getDayOfMonth(), $this$withYear.getHour(), $this$withYear.getMinute(), $this$withYear.getSecond(), 0, 64, null);
    }

    @NotNull
    public static final LocalDateTime withHour(@NotNull LocalDateTime $this$withHour, int hour) {
        Intrinsics.checkNotNullParameter((Object)$this$withHour, (String)"<this>");
        return new LocalDateTime($this$withHour.getYear(), $this$withHour.getMonth(), $this$withHour.getDayOfMonth(), hour, $this$withHour.getMinute(), $this$withHour.getSecond(), 0, 64, null);
    }

    @NotNull
    public static final LocalDateTime withMinute(@NotNull LocalDateTime $this$withMinute, int minute) {
        Intrinsics.checkNotNullParameter((Object)$this$withMinute, (String)"<this>");
        return new LocalDateTime($this$withMinute.getYear(), $this$withMinute.getMonth(), $this$withMinute.getDayOfMonth(), $this$withMinute.getHour(), minute, $this$withMinute.getSecond(), 0, 64, null);
    }

    @NotNull
    public static final LocalTime withHour(@NotNull LocalTime $this$withHour, int hour) {
        Intrinsics.checkNotNullParameter((Object)$this$withHour, (String)"<this>");
        return new LocalTime(hour, $this$withHour.getMinute(), $this$withHour.getSecond(), 0, 8, null);
    }

    @NotNull
    public static final LocalTime withMinute(@NotNull LocalTime $this$withMinute, int minute) {
        Intrinsics.checkNotNullParameter((Object)$this$withMinute, (String)"<this>");
        return new LocalTime($this$withMinute.getHour(), minute, $this$withMinute.getSecond(), 0, 8, null);
    }

    public static final boolean isLeapYear(int year) {
        long prolepticYear = year;
        return (prolepticYear & 3L) == 0L && (prolepticYear % (long)100 != 0L || prolepticYear % (long)400 == 0L);
    }

    @NotNull
    public static final String shortMonths(int month) {
        return switch (month) {
            case 1 -> "Jan";
            case 2 -> "Feb";
            case 3 -> "Mar";
            case 4 -> "Apr";
            case 5 -> "May";
            case 6 -> "Jun";
            case 7 -> "Jul";
            case 8 -> "Aug";
            case 9 -> "Sep";
            case 10 -> "Oct";
            case 11 -> "Nov";
            case 12 -> "Dec";
            default -> "";
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalize(@NotNull String $this$capitalize) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
        String string3 = $this$capitalize.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = string3;
        if (((CharSequence)string4).length() > 0) {
            void it;
            char c = string4.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it) ? CharsKt.titlecase((char)it) : String.valueOf((char)it)));
            String string5 = string4;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string4;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LocalTime truncateTo(@NotNull LocalTime $this$truncateTo, @NotNull DateTimeUnit.TimeBased unit) {
        void it;
        Intrinsics.checkNotNullParameter((Object)$this$truncateTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        long l = $this$truncateTo.toNanosecondOfDay();
        LocalTime.Companion companion = LocalTime.Companion;
        boolean bl = false;
        void var6_5 = it - it % unit.getNanoseconds();
        return companion.fromNanosecondOfDay((long)var6_5);
    }

    @NotNull
    public static final LocalDateTime truncateTo(@NotNull LocalDateTime $this$truncateTo, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter((Object)$this$truncateTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return new LocalDateTime($this$truncateTo.getDate(), DateCommonUtilsKt.truncateTo($this$truncateTo.getTime(), unit));
    }

    @NotNull
    public static final String shortDayOfWeek(int dayOfWeek) {
        return switch (dayOfWeek) {
            case 1 -> "Mon";
            case 2 -> "Tue";
            case 3 -> "Wed";
            case 4 -> "Thu";
            case 5 -> "Fri";
            case 6 -> "Sat";
            case 7 -> "Sun";
            default -> "";
        };
    }

    @NotNull
    public static final String toMonthYear(@NotNull LocalDate $this$toMonthYear) {
        Intrinsics.checkNotNullParameter((Object)$this$toMonthYear, (String)"<this>");
        return DateCommonUtilsKt.firstLetterUppercase(DateCommonUtilsKt.asString($this$toMonthYear, MONTH_YEAR));
    }

    @NotNull
    public static final String toShortDay(@NotNull LocalDate $this$toShortDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toShortDay, (String)"<this>");
        String string2 = DateCommonUtilsKt.asString($this$toShortDay, SHORT_DAY).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    @NotNull
    public static final String asString(@NotNull LocalDate $this$asString, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return DateTimeUtils_androidKt.format($this$asString, format);
    }

    public static /* synthetic */ String asString$default(LocalDate localDate, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = ISO8601;
        }
        return DateCommonUtilsKt.asString(localDate, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String firstLetterUppercase(String $this$firstLetterUppercase) {
        String string2;
        String string3 = $this$firstLetterUppercase;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
            String string6 = string3;
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string2 = stringBuilder2.append(string7).toString();
        } else {
            string2 = string3;
        }
        return string2;
    }

    public static final int monthLength(int $this$monthLength, boolean isLeapYear) {
        return switch ($this$monthLength) {
            case 2 -> {
                if (isLeapYear) {
                    yield 29;
                }
                yield 28;
            }
            case 4, 6, 9, 11 -> 30;
            default -> 31;
        };
    }

    @NotNull
    public static final LocalDate getFirstDayOfWeek() {
        LocalDate today = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()).getDate();
        return DateCommonUtilsKt.daysShift(today, -EntriesMappings.entries$0.indexOf((Object)today.getDayOfWeek()));
    }

    private static final LocalDate daysShift(LocalDate $this$daysShift, int days) {
        return days < 0 ? LocalDateJvmKt.minus((LocalDate)$this$daysShift, (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DayBased(-days))) : (days > 0 ? LocalDateJvmKt.plus((LocalDate)$this$daysShift, (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)new DateTimeUnit.DayBased(days))) : $this$daysShift);
    }

    @NotNull
    public static final Modifier noRippleEffect(@NotNull Modifier $this$noRippleEffect, @NotNull Function0<Unit> onClick) {
        Intrinsics.checkNotNullParameter((Object)$this$noRippleEffect, (String)"<this>");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        return ComposedModifierKt.composed$default((Modifier)$this$noRippleEffect, null, (Function3)((Function3)new Function3<Modifier, Composer, Integer, Modifier>(onClick){
            final /* synthetic */ Function0<Unit> $onClick;
            {
                this.$onClick = $onClick;
            }

            /*
             * WARNING - void declaration
             */
            @Composable
            public final Modifier invoke(Modifier $this$composed, Composer $composer, int $changed) {
                Object object;
                void $this$cache$iv;
                Intrinsics.checkNotNullParameter((Object)$this$composed, (String)"$this$composed");
                $composer.startReplaceGroup(1076593310);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)1076593310, (int)$changed, (int)-1, (String)"network.chaintech.kmp_date_time_picker.utils.noRippleEffect.<anonymous> (DateCommonUtils.kt:212)");
                }
                Modifier modifier = $this$composed;
                $composer.startReplaceGroup(-426732964);
                Composer composer = $composer;
                boolean bl = false;
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv.rememberedValue();
                boolean bl2 = false;
                if (it$iv == Composer.Companion.getEmpty()) {
                    Modifier modifier2 = modifier;
                    boolean bl3 = false;
                    modifier = modifier2;
                    MutableInteractionSource value$iv = InteractionSourceKt.MutableInteractionSource();
                    $this$cache$iv.updateRememberedValue((Object)value$iv);
                    object = value$iv;
                } else {
                    object = it$iv;
                }
                MutableInteractionSource mutableInteractionSource = (MutableInteractionSource)object;
                $composer.endReplaceGroup();
                Modifier modifier3 = ClickableKt.clickable-O2vRcR0$default((Modifier)modifier, (MutableInteractionSource)mutableInteractionSource, null, (boolean)false, null, null, this.$onClick, (int)28, null);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
                return modifier3;
            }
        }), (int)1, null);
    }

    @NotNull
    public static final String dateTimeToString(@NotNull LocalDateTime currentDateTime, @NotNull String givenFormat) {
        Intrinsics.checkNotNullParameter((Object)currentDateTime, (String)"currentDateTime");
        Intrinsics.checkNotNullParameter((Object)givenFormat, (String)"givenFormat");
        return DateTimeUtils_androidKt.format(currentDateTime, givenFormat);
    }

    @NotNull
    public static final String timeToString(@NotNull LocalTime currentTime, @NotNull String givenFormat) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        Intrinsics.checkNotNullParameter((Object)givenFormat, (String)"givenFormat");
        return DateTimeUtils_androidKt.format(currentTime, givenFormat);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DayOfMonth> calculateDayOfMonths(int month, int year) {
        void $this$mapTo$iv$iv;
        int n;
        void $this$mapTo$iv$iv2;
        int n2;
        void $this$mapTo$iv$iv3;
        int n3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        boolean isLeapYear = DateCommonUtilsKt.isLeapYear(year);
        Iterable $this$map$iv = (Iterable)new IntRange(1, 31);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv4.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n4 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            n3 = 0;
            collection.add(new DayOfMonth(String.valueOf((int)it), (int)it, (int)(it - true)));
        }
        List month31day = (List)destination$iv$iv;
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, 30);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv3.iterator();
        while (item$iv$iv.hasNext()) {
            void it;
            int item$iv$iv2;
            n3 = item$iv$iv2 = ((IntIterator)item$iv$iv).nextInt();
            collection = destination$iv$iv2;
            n2 = 0;
            collection.add(new DayOfMonth(String.valueOf((int)it), (int)it, (int)(it - true)));
        }
        List month30day = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = (Iterable)new IntRange(1, 29);
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator item$iv$iv2 = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            void it;
            int item$iv$iv3;
            n2 = item$iv$iv3 = ((IntIterator)item$iv$iv2).nextInt();
            collection = destination$iv$iv3;
            n = 0;
            collection.add(new DayOfMonth(String.valueOf((int)it), (int)it, (int)(it - true)));
        }
        List month29day = (List)destination$iv$iv3;
        Iterable $this$map$iv4 = (Iterable)new IntRange(1, 28);
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv4;
            n = item$iv$iv4 = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(new DayOfMonth(String.valueOf((int)it), (int)it, (int)(it - true)));
        }
        List month28day = (List)destination$iv$iv4;
        return switch (month) {
            case 1 -> month31day;
            case 2 -> {
                if (isLeapYear) {
                    yield month29day;
                }
                yield month28day;
            }
            case 3 -> month31day;
            case 4 -> month30day;
            case 5 -> month31day;
            case 6 -> month30day;
            case 7 -> month31day;
            case 8 -> month31day;
            case 9 -> month30day;
            case 10 -> month31day;
            case 11 -> month30day;
            case 12 -> month31day;
            default -> CollectionsKt.emptyList();
        };
    }

    public static final int localTimeToAmPmHour(@NotNull LocalTime localTime) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        if (DateCommonUtilsKt.isBetween(localTime, new LocalTime(0, 0, 0, 0, 12, null), new LocalTime(0, 59, 0, 0, 12, null))) {
            return localTime.getHour() + 12;
        }
        if (DateCommonUtilsKt.isBetween(localTime, new LocalTime(1, 0, 0, 0, 12, null), new LocalTime(11, 59, 0, 0, 12, null))) {
            return localTime.getHour();
        }
        if (DateCommonUtilsKt.isBetween(localTime, new LocalTime(12, 0, 0, 0, 12, null), new LocalTime(12, 59, 0, 0, 12, null))) {
            return localTime.getHour();
        }
        if (DateCommonUtilsKt.isBetween(localTime, new LocalTime(13, 0, 0, 0, 12, null), new LocalTime(23, 59, 0, 0, 12, null))) {
            return localTime.getHour() - 12;
        }
        return localTime.getHour();
    }

    public static final boolean isBetween(@NotNull LocalTime localTime, @NotNull LocalTime startTime, @NotNull LocalTime endTime) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return 0 <= ((Comparable)localTime).compareTo(startTime) ? ((Comparable)localTime).compareTo(endTime) <= 0 : false;
    }

    public static final int amPmHourToHour24(int amPmHour, int amPmMinute, @NotNull AmPmValue amPmValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)amPmValue), (String)"amPmValue");
        return switch (WhenMappings.$EnumSwitchMapping$0[amPmValue.ordinal()]) {
            case 1 -> {
                if (amPmHour == 12 && amPmMinute <= 59) {
                    yield 0;
                }
                yield amPmHour;
            }
            case 2 -> {
                if (amPmHour == 12 && amPmMinute <= 59) {
                    yield amPmHour;
                }
                yield amPmHour + 12;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final AmPmValue amPmValueFromTime(@NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return time.getHour() > 11 ? AmPmValue.PM : AmPmValue.AM;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DayOfWeek> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])DayOfWeek.values());
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmPmValue.values().length];
            try {
                nArray[AmPmValue.AM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmPmValue.PM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

