package network.chaintech.kmp_date_time_picker

import kotlinx.cinterop.ExperimentalForeignApi
import kotlinx.cinterop.convert
import kotlinx.datetime.LocalDate
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.LocalTime
import kotlinx.datetime.TimeZone
import kotlinx.datetime.toKotlinInstant
import kotlinx.datetime.toLocalDateTime
import platform.Foundation.NSCalendar
import platform.Foundation.NSDate
import platform.Foundation.NSDateComponents
import platform.Foundation.NSDateFormatter
import platform.Foundation.NSLocale
import platform.Foundation.currentLocale

@OptIn(ExperimentalForeignApi::class)
private fun LocalDateTime.toNsDate(): NSDate? {
    val calendar = NSCalendar.currentCalendar
    val components = NSDateComponents()
    components.year = this.year.convert()
    components.month = this.monthNumber.convert()
    components.day = this.dayOfMonth.convert()
    components.hour = this.hour.convert()
    components.minute = this.minute.convert()
    components.second = this.second.convert()
    return calendar.dateFromComponents(components)
}

@OptIn(ExperimentalForeignApi::class)
private fun LocalTime.toNsDate(): NSDate? {
    val calendar = NSCalendar.currentCalendar
    val components = NSDateComponents()
    components.hour = this.hour.convert()
    components.minute = this.minute.convert()
    components.second = this.second.convert()
    return calendar.dateFromComponents(components)
}

@OptIn(ExperimentalForeignApi::class)
private fun LocalDate.toNsDate(): NSDate? {
    val calendar = NSCalendar.currentCalendar
    val components = NSDateComponents()
    components.year = this.year.convert()
    components.month = this.monthNumber.convert()
    components.day = this.dayOfMonth.convert()
    return calendar.dateFromComponents(components)
}

actual fun format(localDateTime: LocalDateTime, outputFormat: String): String {
    val date = localDateTime.toNsDate()
        ?: throw IllegalStateException("Failed to convert LocalDateTime $LocalDateTime to NSDate")
    val formatter = NSDateFormatter().apply {
        dateFormat = outputFormat
        locale = NSLocale.currentLocale
    }
    return formatter.stringFromDate(date)
}

actual fun parse(strDateTime: String, dateFormat: String): LocalDateTime {
    val formatter = NSDateFormatter().apply {
        this.dateFormat = dateFormat
        locale = NSLocale.currentLocale
    }
    return formatter
        .dateFromString(strDateTime)
        ?.toKotlinInstant()
        ?.toLocalDateTime(TimeZone.currentSystemDefault())
        ?: throw IllegalStateException("Failed to convert String $strDateTime to LocalDateTime")
}

actual fun format(localTime: LocalTime, outputFormat: String): String {
    val date = localTime.toNsDate()
        ?: throw IllegalStateException("Failed to convert LocalDateTime $LocalDateTime to NSDate")
    val formatter = NSDateFormatter().apply {
        dateFormat = outputFormat
        locale = NSLocale.currentLocale
    }
    return formatter.stringFromDate(date)
}

actual fun format(localDate: LocalDate, outputFormat: String): String {
    val date = localDate.toNsDate()
        ?: throw IllegalStateException("Failed to convert LocalDateTime $LocalDateTime to NSDate")
    val formatter = NSDateFormatter().apply {
        dateFormat = outputFormat
        locale = NSLocale.currentLocale
    }
    return formatter.stringFromDate(date)
}