/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import lombok.NonNull;
import org.stellar.sdk.AssetCodeLengthInvalidException;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.AssetTypePoolShare;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.Network;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.ContractIDPreimageType;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;

public abstract class Asset
implements Comparable<Asset> {
    Asset() {
    }

    public static Asset create(String canonicalForm) {
        if (canonicalForm.equals("native")) {
            return Asset.create(canonicalForm, null, null);
        }
        String[] parts = canonicalForm.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid asset " + canonicalForm);
        }
        return Asset.create(null, parts[0], parts[1]);
    }

    public static Asset create(String type, String code, String issuer) {
        return Asset.create(type, code, issuer, null);
    }

    public static Asset create(String type, String code, String issuer, String liquidityPoolID) {
        if (type == null) {
            return Asset.createNonNativeAsset(code, issuer);
        }
        if (type.equals("native")) {
            return new AssetTypeNative();
        }
        if (type.equals("liquidity_pool_shares")) {
            return new AssetTypePoolShare(liquidityPoolID);
        }
        return Asset.createNonNativeAsset(code, issuer);
    }

    public static Asset create(ChangeTrustAsset.Wrapper wrapped) {
        return wrapped.getAsset();
    }

    public static Asset create(TrustLineAsset.Wrapper wrapped) {
        return wrapped.getAsset();
    }

    public static Asset fromXdr(org.stellar.sdk.xdr.Asset xdr) {
        switch (xdr.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return new AssetTypeNative();
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                String assetCode4 = Util.paddedByteArrayToString(xdr.getAlphaNum4().getAssetCode().getAssetCode4());
                String accountId = StrKey.encodeEd25519PublicKey(xdr.getAlphaNum4().getIssuer());
                return new AssetTypeCreditAlphaNum4(assetCode4, accountId);
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                String assetCode12 = Util.paddedByteArrayToString(xdr.getAlphaNum12().getAssetCode().getAssetCode12());
                String accountId = StrKey.encodeEd25519PublicKey(xdr.getAlphaNum12().getIssuer());
                return new AssetTypeCreditAlphaNum12(assetCode12, accountId);
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + xdr.getDiscriminant());
    }

    public abstract String getType();

    public abstract org.stellar.sdk.xdr.Asset toXdr();

    public abstract boolean equals(Object var1);

    @Override
    public abstract int compareTo(@NonNull Asset var1);

    private static Asset createNonNativeAsset(String code, String issuer) {
        if (!code.isEmpty() && code.length() <= 4) {
            return new AssetTypeCreditAlphaNum4(code, issuer);
        }
        if (code.length() >= 5 && code.length() <= 12) {
            return new AssetTypeCreditAlphaNum12(code, issuer);
        }
        throw new AssetCodeLengthInvalidException();
    }

    public String getContractId(Network network) throws IOException {
        HashIDPreimage preimage = new HashIDPreimage.Builder().discriminant(EnvelopeType.ENVELOPE_TYPE_CONTRACT_ID).contractID(new HashIDPreimage.HashIDPreimageContractID.Builder().networkID(new Hash(network.getNetworkId())).contractIDPreimage(new ContractIDPreimage.Builder().discriminant(ContractIDPreimageType.CONTRACT_ID_PREIMAGE_FROM_ASSET).fromAsset(this.toXdr()).build()).build()).build();
        byte[] rawContractId = Util.hash(preimage.toXdrByteArray());
        return StrKey.encodeContract(rawContractId);
    }
}

