/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class BeginSponsoringFutureReservesOperation
extends Operation {
    @NonNull
    private final String sponsoredId;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        BeginSponsoringFutureReservesOp op = new BeginSponsoringFutureReservesOp();
        op.setSponsoredID(StrKey.encodeToXDRAccountId(this.sponsoredId));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.BEGIN_SPONSORING_FUTURE_RESERVES);
        body.setBeginSponsoringFutureReservesOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getSponsoredId() {
        return this.sponsoredId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeginSponsoringFutureReservesOperation)) {
            return false;
        }
        BeginSponsoringFutureReservesOperation other = (BeginSponsoringFutureReservesOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sponsoredId = this.getSponsoredId();
        String other$sponsoredId = other.getSponsoredId();
        return !(this$sponsoredId == null ? other$sponsoredId != null : !this$sponsoredId.equals(other$sponsoredId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BeginSponsoringFutureReservesOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sponsoredId = this.getSponsoredId();
        result = result * 59 + ($sponsoredId == null ? 43 : $sponsoredId.hashCode());
        return result;
    }

    @Generated
    private BeginSponsoringFutureReservesOperation(@NonNull String sponsoredId) {
        if (sponsoredId == null) {
            throw new NullPointerException("sponsoredId is marked non-null but is null");
        }
        this.sponsoredId = sponsoredId;
    }

    public static class Builder {
        private final String sponsoredId;
        private String sourceAccount;

        Builder(BeginSponsoringFutureReservesOp op) {
            this.sponsoredId = StrKey.encodeEd25519PublicKey(op.getSponsoredID());
        }

        public Builder(String sponsoredId) {
            this.sponsoredId = sponsoredId;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public BeginSponsoringFutureReservesOperation build() {
            BeginSponsoringFutureReservesOperation operation = new BeginSponsoringFutureReservesOperation(this.sponsoredId);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

