/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.Account;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Network;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.FeeBumpTransactionEnvelope;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;

public class FeeBumpTransaction
extends AbstractTransaction {
    private final long fee;
    @NonNull
    private final String feeAccount;
    @NonNull
    private final Transaction innerTransaction;

    FeeBumpTransaction(AccountConverter accountConverter, @NonNull String feeAccount, long fee, @NonNull Transaction innerTransaction) {
        super(accountConverter, innerTransaction.getNetwork());
        if (feeAccount == null) {
            throw new NullPointerException("feeAccount is marked non-null but is null");
        }
        if (innerTransaction == null) {
            throw new NullPointerException("innerTransaction is marked non-null but is null");
        }
        this.feeAccount = feeAccount;
        this.innerTransaction = innerTransaction;
        this.fee = fee;
    }

    public static FeeBumpTransaction fromFeeBumpTransactionEnvelope(AccountConverter accountConverter, FeeBumpTransactionEnvelope envelope, Network network) {
        Transaction inner = Transaction.fromV1EnvelopeXdr(accountConverter, envelope.getTx().getInnerTx().getV1(), network);
        String feeAccount = accountConverter.decode(envelope.getTx().getFeeSource());
        long fee = envelope.getTx().getFee().getInt64();
        FeeBumpTransaction feeBump = new FeeBumpTransaction(accountConverter, feeAccount, fee, inner);
        feeBump.signatures.addAll(Arrays.asList(envelope.getSignatures()));
        return feeBump;
    }

    public static FeeBumpTransaction fromFeeBumpTransactionEnvelope(FeeBumpTransactionEnvelope envelope, Network network) {
        return FeeBumpTransaction.fromFeeBumpTransactionEnvelope(AccountConverter.enableMuxed(), envelope, network);
    }

    private org.stellar.sdk.xdr.FeeBumpTransaction toXdr() {
        org.stellar.sdk.xdr.FeeBumpTransaction xdr = new org.stellar.sdk.xdr.FeeBumpTransaction();
        xdr.setExt(new FeeBumpTransaction.FeeBumpTransactionExt());
        xdr.getExt().setDiscriminant(0);
        Int64 xdrFee = new Int64();
        xdrFee.setInt64(this.fee);
        xdr.setFee(xdrFee);
        xdr.setFeeSource(this.accountConverter.encode(this.feeAccount));
        FeeBumpTransaction.FeeBumpTransactionInnerTx innerXDR = new FeeBumpTransaction.FeeBumpTransactionInnerTx();
        innerXDR.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        innerXDR.setV1(this.innerTransaction.toEnvelopeXdr().getV1());
        xdr.setInnerTx(innerXDR);
        return xdr;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        taggedTransaction.setFeeBump(this.toXdr());
        return FeeBumpTransaction.getTransactionSignatureBase(taggedTransaction, this.network);
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        FeeBumpTransactionEnvelope feeBumpEnvelope = new FeeBumpTransactionEnvelope();
        xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        feeBumpEnvelope.setTx(this.toXdr());
        DecoratedSignature[] signatures = new DecoratedSignature[this.signatures.size()];
        signatures = this.signatures.toArray(signatures);
        feeBumpEnvelope.setSignatures(signatures);
        xdr.setFeeBump(feeBumpEnvelope);
        return xdr;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FeeBumpTransaction that = (FeeBumpTransaction)object;
        return Arrays.equals(this.signatureBase(), that.signatureBase());
    }

    public int hashCode() {
        return Arrays.hashCode(this.signatureBase());
    }

    @Generated
    public long getFee() {
        return this.fee;
    }

    @NonNull
    @Generated
    public String getFeeAccount() {
        return this.feeAccount;
    }

    @NonNull
    @Generated
    public Transaction getInnerTransaction() {
        return this.innerTransaction;
    }

    public static class Builder {
        private final Transaction innerTransaction;
        private Long baseFee;
        private String feeAccount;
        private final AccountConverter accountConverter;

        public Builder(@NonNull AccountConverter accountConverter, @NonNull Transaction inner) {
            if (accountConverter == null) {
                throw new NullPointerException("accountConverter is marked non-null but is null");
            }
            if (inner == null) {
                throw new NullPointerException("inner is marked non-null but is null");
            }
            EnvelopeType txType = inner.toEnvelopeXdr().getDiscriminant();
            this.accountConverter = accountConverter;
            if (txType == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
                this.innerTransaction = new TransactionBuilder(inner.accountConverter, new Account(inner.getSourceAccount(), inner.getSequenceNumber() - 1L), inner.getNetwork()).setBaseFee((int)inner.getFee()).addOperations(Arrays.asList(inner.getOperations())).addMemo(inner.getMemo()).addPreconditions(new TransactionPreconditions.TransactionPreconditionsBuilder().timeBounds(inner.getTimeBounds()).build()).build();
                this.innerTransaction.signatures = new ArrayList(inner.signatures);
            } else {
                this.innerTransaction = inner;
            }
        }

        public Builder(Transaction inner) {
            this(AccountConverter.enableMuxed(), inner);
        }

        public Builder setBaseFee(long baseFee) {
            if (this.baseFee != null) {
                throw new RuntimeException("base fee has been already set.");
            }
            if (baseFee < 100L) {
                throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
            }
            long innerBaseFee = this.innerTransaction.getFee();
            long numOperations = this.innerTransaction.getOperations().length;
            if (numOperations > 0L) {
                innerBaseFee /= numOperations;
            }
            if (baseFee < innerBaseFee) {
                throw new IllegalArgumentException("base fee cannot be lower than provided inner transaction base fee");
            }
            long maxFee = baseFee * (numOperations + 1L);
            if (maxFee < 0L) {
                throw new IllegalArgumentException("fee overflows 64 bit int");
            }
            this.baseFee = maxFee;
            return this;
        }

        public Builder setFeeAccount(@NonNull String feeAccount) {
            if (feeAccount == null) {
                throw new NullPointerException("feeAccount is marked non-null but is null");
            }
            if (this.feeAccount != null) {
                throw new RuntimeException("fee account has been already been set.");
            }
            this.feeAccount = feeAccount;
            return this;
        }

        public FeeBumpTransaction build() {
            if (this.feeAccount == null) {
                throw new NullPointerException("fee account has to be set. you must call setFeeAccount().");
            }
            if (this.baseFee == null) {
                throw new NullPointerException("base fee has to be set. you must call setBaseFee().");
            }
            return new FeeBumpTransaction(this.accountConverter, this.feeAccount, this.baseFee, this.innerTransaction);
        }
    }
}

