/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.LiquidityPoolParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;

public final class LiquidityPoolConstantProductParameters
extends org.stellar.sdk.LiquidityPoolParameters {
    private final Asset assetA;
    private final Asset assetB;
    private final int fee;

    @Override
    public LiquidityPoolParameters toXdr() {
        LiquidityPoolParameters xdr = new LiquidityPoolParameters();
        xdr.setDiscriminant(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT);
        org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters params = new org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters();
        params.setAssetA(this.assetA.toXdr());
        params.setAssetB(this.assetB.toXdr());
        params.setFee(new Int32(this.fee));
        xdr.setConstantProduct(params);
        return xdr;
    }

    public static LiquidityPoolConstantProductParameters fromXdr(org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters xdr) {
        return new LiquidityPoolConstantProductParameters(Asset.fromXdr(xdr.getAssetA()), Asset.fromXdr(xdr.getAssetB()), xdr.getFee().getInt32());
    }

    @Override
    public LiquidityPoolID getId() {
        return new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, this.assetA, this.assetB, this.fee);
    }

    @Generated
    public LiquidityPoolConstantProductParameters(Asset assetA, Asset assetB, int fee) {
        this.assetA = assetA;
        this.assetB = assetB;
        this.fee = fee;
    }

    @Generated
    public Asset getAssetA() {
        return this.assetA;
    }

    @Generated
    public Asset getAssetB() {
        return this.assetB;
    }

    @Generated
    public int getFee() {
        return this.fee;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolConstantProductParameters(assetA=" + this.getAssetA() + ", assetB=" + this.getAssetB() + ", fee=" + this.getFee() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolConstantProductParameters)) {
            return false;
        }
        LiquidityPoolConstantProductParameters other = (LiquidityPoolConstantProductParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFee() != other.getFee()) {
            return false;
        }
        Asset this$assetA = this.getAssetA();
        Asset other$assetA = other.getAssetA();
        if (this$assetA == null ? other$assetA != null : !((Object)this$assetA).equals(other$assetA)) {
            return false;
        }
        Asset this$assetB = this.getAssetB();
        Asset other$assetB = other.getAssetB();
        return !(this$assetB == null ? other$assetB != null : !((Object)this$assetB).equals(other$assetB));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolConstantProductParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFee();
        Asset $assetA = this.getAssetA();
        result = result * 59 + ($assetA == null ? 43 : $assetA.hashCode());
        Asset $assetB = this.getAssetB();
        result = result * 59 + ($assetB == null ? 43 : $assetB.hashCode());
        return result;
    }
}

