/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.AssetAmount;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.LiquidityPoolParameters;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class LiquidityPoolWithdrawOperation
extends Operation {
    @NonNull
    private final LiquidityPoolID liquidityPoolID;
    @NonNull
    private final String amount;
    @NonNull
    private final String minAmountA;
    @NonNull
    private final String minAmountB;

    public LiquidityPoolWithdrawOperation(LiquidityPoolWithdrawOp op) {
        this.liquidityPoolID = LiquidityPoolID.fromXdr(op.getLiquidityPoolID());
        this.amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        this.minAmountA = Operation.fromXdrAmount(op.getMinAmountA().getInt64());
        this.minAmountB = Operation.fromXdrAmount(op.getMinAmountB().getInt64());
    }

    public LiquidityPoolWithdrawOperation(AssetAmount a, AssetAmount b, @NonNull String amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.liquidityPoolID = new LiquidityPoolID(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT, a.getAsset(), b.getAsset(), LiquidityPoolParameters.Fee);
        this.amount = amount;
        this.minAmountA = a.getAmount();
        this.minAmountB = b.getAmount();
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        LiquidityPoolWithdrawOp op = new LiquidityPoolWithdrawOp();
        op.setLiquidityPoolID(this.getLiquidityPoolID().toXdr());
        op.setAmount(new Int64(Operation.toXdrAmount(this.getAmount())));
        op.setMinAmountA(new Int64(Operation.toXdrAmount(this.getMinAmountA())));
        op.setMinAmountB(new Int64(Operation.toXdrAmount(this.getMinAmountB())));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_WITHDRAW);
        body.setLiquidityPoolWithdrawOp(op);
        return body;
    }

    @NonNull
    @Generated
    public LiquidityPoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    @NonNull
    @Generated
    public String getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public String getMinAmountA() {
        return this.minAmountA;
    }

    @NonNull
    @Generated
    public String getMinAmountB() {
        return this.minAmountB;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolWithdrawOperation)) {
            return false;
        }
        LiquidityPoolWithdrawOperation other = (LiquidityPoolWithdrawOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LiquidityPoolID this$liquidityPoolID = this.getLiquidityPoolID();
        LiquidityPoolID other$liquidityPoolID = other.getLiquidityPoolID();
        if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$minAmountA = this.getMinAmountA();
        String other$minAmountA = other.getMinAmountA();
        if (this$minAmountA == null ? other$minAmountA != null : !this$minAmountA.equals(other$minAmountA)) {
            return false;
        }
        String this$minAmountB = this.getMinAmountB();
        String other$minAmountB = other.getMinAmountB();
        return !(this$minAmountB == null ? other$minAmountB != null : !this$minAmountB.equals(other$minAmountB));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolWithdrawOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LiquidityPoolID $liquidityPoolID = this.getLiquidityPoolID();
        result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $minAmountA = this.getMinAmountA();
        result = result * 59 + ($minAmountA == null ? 43 : $minAmountA.hashCode());
        String $minAmountB = this.getMinAmountB();
        result = result * 59 + ($minAmountB == null ? 43 : $minAmountB.hashCode());
        return result;
    }

    @Generated
    public LiquidityPoolWithdrawOperation(@NonNull LiquidityPoolID liquidityPoolID, @NonNull String amount, @NonNull String minAmountA, @NonNull String minAmountB) {
        if (liquidityPoolID == null) {
            throw new NullPointerException("liquidityPoolID is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (minAmountA == null) {
            throw new NullPointerException("minAmountA is marked non-null but is null");
        }
        if (minAmountB == null) {
            throw new NullPointerException("minAmountB is marked non-null but is null");
        }
        this.liquidityPoolID = liquidityPoolID;
        this.amount = amount;
        this.minAmountA = minAmountA;
        this.minAmountB = minAmountB;
    }
}

