/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Util;

public class Network {
    public static final Network PUBLIC = new Network("Public Global Stellar Network ; September 2015");
    public static final Network TESTNET = new Network("Test SDF Network ; September 2015");
    public static final Network FUTURENET = new Network("Test SDF Future Network ; October 2022");
    public static final Network STANDALONE = new Network("Standalone Network ; February 2017");
    public static final Network SANDBOX = new Network("Local Sandbox Stellar Network ; September 2022");
    @NonNull
    private final String networkPassphrase;

    public Network(@NonNull String networkPassphrase) {
        if (networkPassphrase == null) {
            throw new NullPointerException("networkPassphrase is marked non-null but is null");
        }
        this.networkPassphrase = networkPassphrase;
    }

    public byte[] getNetworkId() {
        return Util.hash(this.networkPassphrase.getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return this.networkPassphrase;
    }

    @NonNull
    @Generated
    public String getNetworkPassphrase() {
        return this.networkPassphrase;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Network)) {
            return false;
        }
        Network other = (Network)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$networkPassphrase = this.getNetworkPassphrase();
        String other$networkPassphrase = other.getNetworkPassphrase();
        return !(this$networkPassphrase == null ? other$networkPassphrase != null : !this$networkPassphrase.equals(other$networkPassphrase));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Network;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $networkPassphrase = this.getNetworkPassphrase();
        result = result * 59 + ($networkPassphrase == null ? 43 : $networkPassphrase.hashCode());
        return result;
    }
}

