/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.AccountMergeOperation;
import org.stellar.sdk.AllowTrustOperation;
import org.stellar.sdk.BeginSponsoringFutureReservesOperation;
import org.stellar.sdk.BumpSequenceOperation;
import org.stellar.sdk.ChangeTrustOperation;
import org.stellar.sdk.ClaimClaimableBalanceOperation;
import org.stellar.sdk.ClawbackClaimableBalanceOperation;
import org.stellar.sdk.ClawbackOperation;
import org.stellar.sdk.CreateAccountOperation;
import org.stellar.sdk.CreateClaimableBalanceOperation;
import org.stellar.sdk.CreatePassiveSellOfferOperation;
import org.stellar.sdk.EndSponsoringFutureReservesOperation;
import org.stellar.sdk.ExtendFootprintTTLOperation;
import org.stellar.sdk.InflationOperation;
import org.stellar.sdk.InvokeHostFunctionOperation;
import org.stellar.sdk.LiquidityPoolDepositOperation;
import org.stellar.sdk.LiquidityPoolWithdrawOperation;
import org.stellar.sdk.ManageBuyOfferOperation;
import org.stellar.sdk.ManageDataOperation;
import org.stellar.sdk.ManageSellOfferOperation;
import org.stellar.sdk.PathPaymentStrictReceiveOperation;
import org.stellar.sdk.PathPaymentStrictSendOperation;
import org.stellar.sdk.PaymentOperation;
import org.stellar.sdk.RestoreFootprintOperation;
import org.stellar.sdk.RevokeAccountSponsorshipOperation;
import org.stellar.sdk.RevokeClaimableBalanceSponsorshipOperation;
import org.stellar.sdk.RevokeDataSponsorshipOperation;
import org.stellar.sdk.RevokeOfferSponsorshipOperation;
import org.stellar.sdk.RevokeSignerSponsorshipOperation;
import org.stellar.sdk.RevokeTrustlineSponsorshipOperation;
import org.stellar.sdk.SetOptionsOperation;
import org.stellar.sdk.SetTrustlineFlagsOperation;
import org.stellar.sdk.xdr.Operation;

public abstract class Operation {
    private String sourceAccount;
    private static final BigDecimal ONE = new BigDecimal(10).pow(7);

    Operation() {
    }

    protected static long toXdrAmount(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        BigDecimal amount = new BigDecimal(value).multiply(ONE);
        return amount.longValueExact();
    }

    protected static String fromXdrAmount(long value) {
        BigDecimal amount = new BigDecimal(value).divide(ONE);
        return amount.toPlainString();
    }

    public org.stellar.sdk.xdr.Operation toXdr(AccountConverter accountConverter) {
        org.stellar.sdk.xdr.Operation xdr = new org.stellar.sdk.xdr.Operation();
        if (this.getSourceAccount() != null) {
            xdr.setSourceAccount(accountConverter.encode(this.sourceAccount));
        }
        xdr.setBody(this.toOperationBody(accountConverter));
        return xdr;
    }

    public org.stellar.sdk.xdr.Operation toXdr() {
        return this.toXdr(AccountConverter.enableMuxed());
    }

    public String toXdrBase64(AccountConverter accountConverter) {
        try {
            return this.toXdr(accountConverter).toXdrBase64();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toXdrBase64() {
        return this.toXdrBase64(AccountConverter.enableMuxed());
    }

    public static Operation fromXdr(AccountConverter accountConverter, org.stellar.sdk.xdr.Operation xdr) {
        Operation operation;
        Operation.OperationBody body = xdr.getBody();
        block0 : switch (body.getDiscriminant()) {
            case CREATE_ACCOUNT: {
                operation = new CreateAccountOperation.Builder(body.getCreateAccountOp()).build();
                break;
            }
            case PAYMENT: {
                operation = new PaymentOperation.Builder(accountConverter, body.getPaymentOp()).build();
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE: {
                operation = new PathPaymentStrictReceiveOperation.Builder(accountConverter, body.getPathPaymentStrictReceiveOp()).build();
                break;
            }
            case MANAGE_SELL_OFFER: {
                operation = new ManageSellOfferOperation.Builder(body.getManageSellOfferOp()).build();
                break;
            }
            case MANAGE_BUY_OFFER: {
                operation = new ManageBuyOfferOperation.Builder(body.getManageBuyOfferOp()).build();
                break;
            }
            case CREATE_PASSIVE_SELL_OFFER: {
                operation = new CreatePassiveSellOfferOperation.Builder(body.getCreatePassiveSellOfferOp()).build();
                break;
            }
            case SET_OPTIONS: {
                operation = new SetOptionsOperation.Builder(body.getSetOptionsOp()).build();
                break;
            }
            case CHANGE_TRUST: {
                operation = new ChangeTrustOperation.Builder(body.getChangeTrustOp()).build();
                break;
            }
            case ALLOW_TRUST: {
                operation = new AllowTrustOperation.Builder(body.getAllowTrustOp()).build();
                break;
            }
            case ACCOUNT_MERGE: {
                operation = new AccountMergeOperation.Builder(accountConverter, body).build();
                break;
            }
            case INFLATION: {
                operation = new InflationOperation();
                break;
            }
            case MANAGE_DATA: {
                operation = new ManageDataOperation.Builder(body.getManageDataOp()).build();
                break;
            }
            case BUMP_SEQUENCE: {
                operation = new BumpSequenceOperation.Builder(body.getBumpSequenceOp()).build();
                break;
            }
            case PATH_PAYMENT_STRICT_SEND: {
                operation = new PathPaymentStrictSendOperation.Builder(accountConverter, body.getPathPaymentStrictSendOp()).build();
                break;
            }
            case CREATE_CLAIMABLE_BALANCE: {
                operation = new CreateClaimableBalanceOperation.Builder(body.getCreateClaimableBalanceOp()).build();
                break;
            }
            case CLAIM_CLAIMABLE_BALANCE: {
                operation = new ClaimClaimableBalanceOperation.Builder(body.getClaimClaimableBalanceOp()).build();
                break;
            }
            case BEGIN_SPONSORING_FUTURE_RESERVES: {
                operation = new BeginSponsoringFutureReservesOperation.Builder(body.getBeginSponsoringFutureReservesOp()).build();
                break;
            }
            case END_SPONSORING_FUTURE_RESERVES: {
                operation = new EndSponsoringFutureReservesOperation();
                break;
            }
            case REVOKE_SPONSORSHIP: {
                switch (body.getRevokeSponsorshipOp().getDiscriminant()) {
                    case REVOKE_SPONSORSHIP_SIGNER: {
                        operation = new RevokeSignerSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                        break block0;
                    }
                    case REVOKE_SPONSORSHIP_LEDGER_ENTRY: {
                        switch (body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant()) {
                            case DATA: {
                                operation = new RevokeDataSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case OFFER: {
                                operation = new RevokeOfferSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case ACCOUNT: {
                                operation = new RevokeAccountSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case TRUSTLINE: {
                                operation = new RevokeTrustlineSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                            case CLAIMABLE_BALANCE: {
                                operation = new RevokeClaimableBalanceSponsorshipOperation.Builder(body.getRevokeSponsorshipOp()).build();
                                break block0;
                            }
                        }
                        throw new RuntimeException("Unknown revoke sponsorship ledger entry type " + body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant());
                    }
                }
                throw new RuntimeException("Unknown revoke sponsorship body " + body.getRevokeSponsorshipOp().getDiscriminant());
            }
            case CLAWBACK: {
                operation = new ClawbackOperation.Builder(accountConverter, body.getClawbackOp()).build();
                break;
            }
            case CLAWBACK_CLAIMABLE_BALANCE: {
                operation = new ClawbackClaimableBalanceOperation.Builder(body.getClawbackClaimableBalanceOp()).build();
                break;
            }
            case SET_TRUST_LINE_FLAGS: {
                operation = new SetTrustlineFlagsOperation.Builder(body.getSetTrustLineFlagsOp()).build();
                break;
            }
            case LIQUIDITY_POOL_DEPOSIT: {
                operation = new LiquidityPoolDepositOperation(body.getLiquidityPoolDepositOp());
                break;
            }
            case LIQUIDITY_POOL_WITHDRAW: {
                operation = new LiquidityPoolWithdrawOperation(body.getLiquidityPoolWithdrawOp());
                break;
            }
            case INVOKE_HOST_FUNCTION: {
                operation = InvokeHostFunctionOperation.fromXdr(body.getInvokeHostFunctionOp());
                break;
            }
            case EXTEND_FOOTPRINT_TTL: {
                operation = ExtendFootprintTTLOperation.fromXdr(body.getExtendFootprintTTLOp());
                break;
            }
            case RESTORE_FOOTPRINT: {
                operation = RestoreFootprintOperation.fromXdr(body.getRestoreFootprintOp());
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation body " + body.getDiscriminant());
            }
        }
        if (xdr.getSourceAccount() != null) {
            operation.setSourceAccount(accountConverter.decode(xdr.getSourceAccount()));
        }
        return operation;
    }

    public static Operation fromXdr(org.stellar.sdk.xdr.Operation xdr) {
        return Operation.fromXdr(AccountConverter.enableMuxed(), xdr);
    }

    abstract Operation.OperationBody toOperationBody(AccountConverter var1);

    @Generated
    protected Operation(OperationBuilder<?, ?> b) {
        this.sourceAccount = ((OperationBuilder)b).sourceAccount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sourceAccount = this.getSourceAccount();
        String other$sourceAccount = other.getSourceAccount();
        return !(this$sourceAccount == null ? other$sourceAccount != null : !this$sourceAccount.equals(other$sourceAccount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceAccount = this.getSourceAccount();
        result = result * 59 + ($sourceAccount == null ? 43 : $sourceAccount.hashCode());
        return result;
    }

    @Generated
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    @Generated
    public static abstract class OperationBuilder<C extends Operation, B extends OperationBuilder<C, B>> {
        @Generated
        private String sourceAccount;

        @Generated
        protected B $fillValuesFrom(C instance) {
            OperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Operation instance, OperationBuilder<?, ?> b) {
            b.sourceAccount(instance.sourceAccount);
        }

        @Generated
        public B sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Operation.OperationBuilder(sourceAccount=" + this.sourceAccount + ")";
        }
    }
}

