/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;

public class PathPaymentStrictReceiveOperation
extends Operation {
    @NonNull
    private final Asset sendAsset;
    @NonNull
    private final String sendMax;
    @NonNull
    private final String destination;
    @NonNull
    private final Asset destAsset;
    @NonNull
    private final String destAmount;
    @NonNull
    private final Asset[] path;

    private PathPaymentStrictReceiveOperation(@NonNull Asset sendAsset, @NonNull String sendMax, @NonNull String destination, @NonNull Asset destAsset, @NonNull String destAmount, Asset[] path) {
        if (sendAsset == null) {
            throw new NullPointerException("sendAsset is marked non-null but is null");
        }
        if (sendMax == null) {
            throw new NullPointerException("sendMax is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (destAsset == null) {
            throw new NullPointerException("destAsset is marked non-null but is null");
        }
        if (destAmount == null) {
            throw new NullPointerException("destAmount is marked non-null but is null");
        }
        this.sendAsset = sendAsset;
        this.sendMax = sendMax;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destAmount = destAmount;
        if (path == null) {
            this.path = new Asset[0];
        } else {
            if (path.length > 5) {
                throw new IllegalArgumentException("The maximum number of assets in the path is 5");
            }
            this.path = path;
        }
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        PathPaymentStrictReceiveOp op = new PathPaymentStrictReceiveOp();
        op.setSendAsset(this.sendAsset.toXdr());
        Int64 sendMax = new Int64();
        sendMax.setInt64(Operation.toXdrAmount(this.sendMax));
        op.setSendMax(sendMax);
        op.setDestination(accountConverter.encode(this.destination));
        op.setDestAsset(this.destAsset.toXdr());
        Int64 destAmount = new Int64();
        destAmount.setInt64(Operation.toXdrAmount(this.destAmount));
        op.setDestAmount(destAmount);
        org.stellar.sdk.xdr.Asset[] path = new org.stellar.sdk.xdr.Asset[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            path[i] = this.path[i].toXdr();
        }
        op.setPath(path);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.PATH_PAYMENT_STRICT_RECEIVE);
        body.setPathPaymentStrictReceiveOp(op);
        return body;
    }

    @NonNull
    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @NonNull
    @Generated
    public String getSendMax() {
        return this.sendMax;
    }

    @NonNull
    @Generated
    public String getDestination() {
        return this.destination;
    }

    @NonNull
    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @NonNull
    @Generated
    public String getDestAmount() {
        return this.destAmount;
    }

    @NonNull
    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictReceiveOperation)) {
            return false;
        }
        PathPaymentStrictReceiveOperation other = (PathPaymentStrictReceiveOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        String this$sendMax = this.getSendMax();
        String other$sendMax = other.getSendMax();
        if (this$sendMax == null ? other$sendMax != null : !this$sendMax.equals(other$sendMax)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        String this$destAmount = this.getDestAmount();
        String other$destAmount = other.getDestAmount();
        if (this$destAmount == null ? other$destAmount != null : !this$destAmount.equals(other$destAmount)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictReceiveOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : $sendAsset.hashCode());
        String $sendMax = this.getSendMax();
        result = result * 59 + ($sendMax == null ? 43 : $sendMax.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : $destAsset.hashCode());
        String $destAmount = this.getDestAmount();
        result = result * 59 + ($destAmount == null ? 43 : $destAmount.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    public static class Builder {
        private final Asset sendAsset;
        private final String sendMax;
        private final String destination;
        private final Asset destAsset;
        private final String destAmount;
        private Asset[] path;
        private String sourceAccount;

        Builder(AccountConverter accountConverter, PathPaymentStrictReceiveOp op) {
            this.sendAsset = Asset.fromXdr(op.getSendAsset());
            this.sendMax = Operation.fromXdrAmount(op.getSendMax().getInt64());
            this.destination = accountConverter.decode(op.getDestination());
            this.destAsset = Asset.fromXdr(op.getDestAsset());
            this.destAmount = Operation.fromXdrAmount(op.getDestAmount().getInt64());
            this.path = new Asset[op.getPath().length];
            for (int i = 0; i < op.getPath().length; ++i) {
                this.path[i] = Asset.fromXdr(op.getPath()[i]);
            }
        }

        public Builder(@NonNull Asset sendAsset, @NonNull String sendMax, @NonNull String destination, @NonNull Asset destAsset, @NonNull String destAmount) {
            if (sendAsset == null) {
                throw new NullPointerException("sendAsset is marked non-null but is null");
            }
            if (sendMax == null) {
                throw new NullPointerException("sendMax is marked non-null but is null");
            }
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            if (destAsset == null) {
                throw new NullPointerException("destAsset is marked non-null but is null");
            }
            if (destAmount == null) {
                throw new NullPointerException("destAmount is marked non-null but is null");
            }
            this.sendAsset = sendAsset;
            this.sendMax = sendMax;
            this.destination = destination;
            this.destAsset = destAsset;
            this.destAmount = destAmount;
        }

        public Builder setPath(@NonNull Asset[] path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (path.length > 5) {
                throw new IllegalArgumentException("The maximum number of assets in the path is 5");
            }
            this.path = path;
            return this;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public PathPaymentStrictReceiveOperation build() {
            PathPaymentStrictReceiveOperation operation = new PathPaymentStrictReceiveOperation(this.sendAsset, this.sendMax, this.destination, this.destAsset, this.destAmount, this.path);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

