/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.xdr.Int32;

public class Price {
    @SerializedName(value="n")
    private final int n;
    @SerializedName(value="d")
    private final int d;

    public Price(int n, int d) {
        this.n = n;
        this.d = d;
    }

    public int getNumerator() {
        return this.n;
    }

    public int getDenominator() {
        return this.d;
    }

    public static Price fromString(@NonNull String price) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        BigDecimal maxInt = new BigDecimal(Integer.MAX_VALUE);
        BigDecimal number = new BigDecimal(price);
        ArrayList<BigDecimal[]> fractions = new ArrayList<BigDecimal[]>();
        fractions.add(new BigDecimal[]{new BigDecimal(0), new BigDecimal(1)});
        fractions.add(new BigDecimal[]{new BigDecimal(1), new BigDecimal(0)});
        int i = 2;
        while (number.compareTo(maxInt) <= 0) {
            BigDecimal a = number.setScale(0, RoundingMode.FLOOR);
            BigDecimal f = number.subtract(a);
            BigDecimal h = a.multiply(((BigDecimal[])fractions.get(i - 1))[0]).add(((BigDecimal[])fractions.get(i - 2))[0]);
            BigDecimal k = a.multiply(((BigDecimal[])fractions.get(i - 1))[1]).add(((BigDecimal[])fractions.get(i - 2))[1]);
            if (h.compareTo(maxInt) > 0 || k.compareTo(maxInt) > 0) break;
            fractions.add(new BigDecimal[]{h, k});
            if (f.compareTo(BigDecimal.ZERO) == 0) break;
            number = new BigDecimal(1).divide(f, 20, RoundingMode.HALF_UP);
            ++i;
        }
        BigDecimal n = ((BigDecimal[])fractions.get(fractions.size() - 1))[0];
        BigDecimal d = ((BigDecimal[])fractions.get(fractions.size() - 1))[1];
        return new Price(n.intValue(), d.intValue());
    }

    public static Price fromXdr(org.stellar.sdk.xdr.Price price) {
        return new Price(price.getN().getInt32(), price.getD().getInt32());
    }

    public org.stellar.sdk.xdr.Price toXdr() {
        org.stellar.sdk.xdr.Price xdr = new org.stellar.sdk.xdr.Price();
        Int32 n = new Int32();
        Int32 d = new Int32();
        n.setInt32(this.n);
        d.setInt32(this.d);
        xdr.setN(n);
        xdr.setD(d);
        return xdr;
    }

    public String toString() {
        MathContext mc = MathContext.DECIMAL64;
        BigDecimal result = new BigDecimal(this.n).divide(new BigDecimal(this.d), mc);
        return result.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Price)) {
            return false;
        }
        Price other = (Price)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.n != other.n) {
            return false;
        }
        return this.d == other.d;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Price;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.n;
        result = result * 59 + this.d;
        return result;
    }
}

