/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeAccountSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.ACCOUNT);
        LedgerKey.LedgerKeyAccount account = new LedgerKey.LedgerKeyAccount();
        account.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        key.setAccount(account);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeAccountSponsorshipOperation)) {
            return false;
        }
        RevokeAccountSponsorshipOperation other = (RevokeAccountSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeAccountSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    @Generated
    private RevokeAccountSponsorshipOperation(@NonNull String accountId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.accountId = accountId;
    }

    public static class Builder {
        private final String accountId;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getAccount().getAccountID());
        }

        public Builder(String accountId) {
            this.accountId = accountId;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeAccountSponsorshipOperation build() {
            RevokeAccountSponsorshipOperation operation = new RevokeAccountSponsorshipOperation(this.accountId);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

