/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;

public class RevokeDataSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final String dataName;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.DATA);
        LedgerKey.LedgerKeyData data = new LedgerKey.LedgerKeyData();
        data.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        String64 dn = new String64();
        dn.setString64(new XdrString(this.dataName));
        data.setDataName(dn);
        key.setData(data);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public String getDataName() {
        return this.dataName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeDataSponsorshipOperation)) {
            return false;
        }
        RevokeDataSponsorshipOperation other = (RevokeDataSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$dataName = this.getDataName();
        String other$dataName = other.getDataName();
        return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeDataSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $dataName = this.getDataName();
        result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
        return result;
    }

    @Generated
    private RevokeDataSponsorshipOperation(@NonNull String accountId, @NonNull String dataName) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (dataName == null) {
            throw new NullPointerException("dataName is marked non-null but is null");
        }
        this.accountId = accountId;
        this.dataName = dataName;
    }

    public static class Builder {
        private final String accountId;
        private final String dataName;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getData().getAccountID());
            this.dataName = op.getLedgerKey().getData().getDataName().getString64().toString();
        }

        public Builder(String accountId, String dataName) {
            this.accountId = accountId;
            this.dataName = dataName;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeDataSponsorshipOperation build() {
            RevokeDataSponsorshipOperation operation = new RevokeDataSponsorshipOperation(this.accountId, this.dataName);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

