/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrString;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class SetOptionsOperation
extends Operation {
    private final String inflationDestination;
    private final Integer clearFlags;
    private final Integer setFlags;
    private final Integer masterKeyWeight;
    private final Integer lowThreshold;
    private final Integer mediumThreshold;
    private final Integer highThreshold;
    private final String homeDomain;
    private final SignerKey signer;
    private final Integer signerWeight;

    private SetOptionsOperation(String inflationDestination, Integer clearFlags, Integer setFlags, Integer masterKeyWeight, Integer lowThreshold, Integer mediumThreshold, Integer highThreshold, String homeDomain, SignerKey signer, Integer signerWeight) {
        this.inflationDestination = inflationDestination;
        this.clearFlags = clearFlags;
        this.setFlags = setFlags;
        this.masterKeyWeight = masterKeyWeight;
        this.lowThreshold = lowThreshold;
        this.mediumThreshold = mediumThreshold;
        this.highThreshold = highThreshold;
        this.homeDomain = homeDomain;
        this.signer = signer;
        this.signerWeight = signerWeight;
        if (this.homeDomain != null && new XdrString(this.homeDomain).getBytes().length > 32) {
            throw new IllegalArgumentException("home domain cannot exceed 32 bytes");
        }
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        Uint32 uint32;
        SetOptionsOp op = new SetOptionsOp();
        if (this.inflationDestination != null) {
            op.setInflationDest(StrKey.encodeToXDRAccountId(this.inflationDestination));
        }
        if (this.clearFlags != null) {
            Uint32 clearFlags = new Uint32();
            clearFlags.setUint32(new XdrUnsignedInteger(this.clearFlags));
            op.setClearFlags(clearFlags);
        }
        if (this.setFlags != null) {
            Uint32 setFlags = new Uint32();
            setFlags.setUint32(new XdrUnsignedInteger(this.setFlags));
            op.setSetFlags(setFlags);
        }
        if (this.masterKeyWeight != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.masterKeyWeight));
            op.setMasterWeight(uint32);
        }
        if (this.lowThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.lowThreshold));
            op.setLowThreshold(uint32);
        }
        if (this.mediumThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.mediumThreshold));
            op.setMedThreshold(uint32);
        }
        if (this.highThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.highThreshold));
            op.setHighThreshold(uint32);
        }
        if (this.homeDomain != null) {
            String32 homeDomain = new String32();
            homeDomain.setString32(new XdrString(this.homeDomain));
            op.setHomeDomain(homeDomain);
        }
        if (this.signer != null) {
            Signer signer = new Signer();
            Uint32 weight = new Uint32();
            weight.setUint32(new XdrUnsignedInteger(this.signerWeight & 0xFF));
            signer.setKey(this.signer);
            signer.setWeight(weight);
            op.setSigner(signer);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_OPTIONS);
        body.setSetOptionsOp(op);
        return body;
    }

    @Generated
    public String getInflationDestination() {
        return this.inflationDestination;
    }

    @Generated
    public Integer getClearFlags() {
        return this.clearFlags;
    }

    @Generated
    public Integer getSetFlags() {
        return this.setFlags;
    }

    @Generated
    public Integer getMasterKeyWeight() {
        return this.masterKeyWeight;
    }

    @Generated
    public Integer getLowThreshold() {
        return this.lowThreshold;
    }

    @Generated
    public Integer getMediumThreshold() {
        return this.mediumThreshold;
    }

    @Generated
    public Integer getHighThreshold() {
        return this.highThreshold;
    }

    @Generated
    public String getHomeDomain() {
        return this.homeDomain;
    }

    @Generated
    public SignerKey getSigner() {
        return this.signer;
    }

    @Generated
    public Integer getSignerWeight() {
        return this.signerWeight;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetOptionsOperation)) {
            return false;
        }
        SetOptionsOperation other = (SetOptionsOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$clearFlags = this.getClearFlags();
        Integer other$clearFlags = other.getClearFlags();
        if (this$clearFlags == null ? other$clearFlags != null : !((Object)this$clearFlags).equals(other$clearFlags)) {
            return false;
        }
        Integer this$setFlags = this.getSetFlags();
        Integer other$setFlags = other.getSetFlags();
        if (this$setFlags == null ? other$setFlags != null : !((Object)this$setFlags).equals(other$setFlags)) {
            return false;
        }
        Integer this$masterKeyWeight = this.getMasterKeyWeight();
        Integer other$masterKeyWeight = other.getMasterKeyWeight();
        if (this$masterKeyWeight == null ? other$masterKeyWeight != null : !((Object)this$masterKeyWeight).equals(other$masterKeyWeight)) {
            return false;
        }
        Integer this$lowThreshold = this.getLowThreshold();
        Integer other$lowThreshold = other.getLowThreshold();
        if (this$lowThreshold == null ? other$lowThreshold != null : !((Object)this$lowThreshold).equals(other$lowThreshold)) {
            return false;
        }
        Integer this$mediumThreshold = this.getMediumThreshold();
        Integer other$mediumThreshold = other.getMediumThreshold();
        if (this$mediumThreshold == null ? other$mediumThreshold != null : !((Object)this$mediumThreshold).equals(other$mediumThreshold)) {
            return false;
        }
        Integer this$highThreshold = this.getHighThreshold();
        Integer other$highThreshold = other.getHighThreshold();
        if (this$highThreshold == null ? other$highThreshold != null : !((Object)this$highThreshold).equals(other$highThreshold)) {
            return false;
        }
        Integer this$signerWeight = this.getSignerWeight();
        Integer other$signerWeight = other.getSignerWeight();
        if (this$signerWeight == null ? other$signerWeight != null : !((Object)this$signerWeight).equals(other$signerWeight)) {
            return false;
        }
        String this$inflationDestination = this.getInflationDestination();
        String other$inflationDestination = other.getInflationDestination();
        if (this$inflationDestination == null ? other$inflationDestination != null : !this$inflationDestination.equals(other$inflationDestination)) {
            return false;
        }
        String this$homeDomain = this.getHomeDomain();
        String other$homeDomain = other.getHomeDomain();
        if (this$homeDomain == null ? other$homeDomain != null : !this$homeDomain.equals(other$homeDomain)) {
            return false;
        }
        SignerKey this$signer = this.getSigner();
        SignerKey other$signer = other.getSigner();
        return !(this$signer == null ? other$signer != null : !((Object)this$signer).equals(other$signer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetOptionsOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $clearFlags = this.getClearFlags();
        result = result * 59 + ($clearFlags == null ? 43 : ((Object)$clearFlags).hashCode());
        Integer $setFlags = this.getSetFlags();
        result = result * 59 + ($setFlags == null ? 43 : ((Object)$setFlags).hashCode());
        Integer $masterKeyWeight = this.getMasterKeyWeight();
        result = result * 59 + ($masterKeyWeight == null ? 43 : ((Object)$masterKeyWeight).hashCode());
        Integer $lowThreshold = this.getLowThreshold();
        result = result * 59 + ($lowThreshold == null ? 43 : ((Object)$lowThreshold).hashCode());
        Integer $mediumThreshold = this.getMediumThreshold();
        result = result * 59 + ($mediumThreshold == null ? 43 : ((Object)$mediumThreshold).hashCode());
        Integer $highThreshold = this.getHighThreshold();
        result = result * 59 + ($highThreshold == null ? 43 : ((Object)$highThreshold).hashCode());
        Integer $signerWeight = this.getSignerWeight();
        result = result * 59 + ($signerWeight == null ? 43 : ((Object)$signerWeight).hashCode());
        String $inflationDestination = this.getInflationDestination();
        result = result * 59 + ($inflationDestination == null ? 43 : $inflationDestination.hashCode());
        String $homeDomain = this.getHomeDomain();
        result = result * 59 + ($homeDomain == null ? 43 : $homeDomain.hashCode());
        SignerKey $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : ((Object)$signer).hashCode());
        return result;
    }

    public static class Builder {
        private String inflationDestination;
        private Integer clearFlags;
        private Integer setFlags;
        private Integer masterKeyWeight;
        private Integer lowThreshold;
        private Integer mediumThreshold;
        private Integer highThreshold;
        private String homeDomain;
        private SignerKey signer;
        private Integer signerWeight;
        private String sourceAccount;

        Builder(SetOptionsOp op) {
            if (op.getInflationDest() != null) {
                this.inflationDestination = StrKey.encodeEd25519PublicKey(op.getInflationDest());
            }
            if (op.getClearFlags() != null) {
                this.clearFlags = op.getClearFlags().getUint32().getNumber().intValue();
            }
            if (op.getSetFlags() != null) {
                this.setFlags = op.getSetFlags().getUint32().getNumber().intValue();
            }
            if (op.getMasterWeight() != null) {
                this.masterKeyWeight = op.getMasterWeight().getUint32().getNumber().intValue();
            }
            if (op.getLowThreshold() != null) {
                this.lowThreshold = op.getLowThreshold().getUint32().getNumber().intValue();
            }
            if (op.getMedThreshold() != null) {
                this.mediumThreshold = op.getMedThreshold().getUint32().getNumber().intValue();
            }
            if (op.getHighThreshold() != null) {
                this.highThreshold = op.getHighThreshold().getUint32().getNumber().intValue();
            }
            if (op.getHomeDomain() != null) {
                this.homeDomain = op.getHomeDomain().getString32().toString();
            }
            if (op.getSigner() != null) {
                this.signer = op.getSigner().getKey();
                this.signerWeight = op.getSigner().getWeight().getUint32().getNumber().intValue() & 0xFF;
            }
        }

        public Builder() {
        }

        public Builder setInflationDestination(String inflationDestination) {
            this.inflationDestination = inflationDestination;
            return this;
        }

        public Builder setClearFlags(int clearFlags) {
            this.clearFlags = clearFlags;
            return this;
        }

        public Builder setSetFlags(int setFlags) {
            this.setFlags = setFlags;
            return this;
        }

        public Builder setMasterKeyWeight(int masterKeyWeight) {
            this.masterKeyWeight = masterKeyWeight;
            return this;
        }

        public Builder setLowThreshold(int lowThreshold) {
            this.lowThreshold = lowThreshold;
            return this;
        }

        public Builder setMediumThreshold(int mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
            return this;
        }

        public Builder setHighThreshold(int highThreshold) {
            this.highThreshold = highThreshold;
            return this;
        }

        public Builder setHomeDomain(String homeDomain) {
            if (homeDomain.length() > 32) {
                throw new IllegalArgumentException("Home domain must be <= 32 characters");
            }
            this.homeDomain = homeDomain;
            return this;
        }

        public Builder setSigner(@NonNull SignerKey signer, @NonNull Integer weight) {
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            if (weight == null) {
                throw new NullPointerException("weight is marked non-null but is null");
            }
            this.signer = signer;
            this.signerWeight = weight & 0xFF;
            return this;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public SetOptionsOperation build() {
            SetOptionsOperation operation = new SetOptionsOperation(this.inflationDestination, this.clearFlags, this.setFlags, this.masterKeyWeight, this.lowThreshold, this.mediumThreshold, this.highThreshold, this.homeDomain, this.signer, this.signerWeight);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

