/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.LedgerResponse;
import org.stellar.sdk.responses.Page;

public class LedgersRequestBuilder
extends RequestBuilder {
    public LedgersRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "ledgers");
    }

    public LedgerResponse ledger(HttpUrl uri) throws IOException {
        TypeToken<LedgerResponse> type = new TypeToken<LedgerResponse>(){};
        ResponseHandler<LedgerResponse> responseHandler = new ResponseHandler<LedgerResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public LedgerResponse ledger(long ledgerSeq) throws IOException {
        this.setSegments("ledgers", String.valueOf(ledgerSeq));
        return this.ledger(this.buildUri());
    }

    public static Page<LedgerResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<LedgerResponse>> type = new TypeToken<Page<LedgerResponse>>(){};
        ResponseHandler<Page<LedgerResponse>> responseHandler = new ResponseHandler<Page<LedgerResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<LedgerResponse> stream(EventListener<LedgerResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, LedgerResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<LedgerResponse> stream(EventListener<LedgerResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<LedgerResponse> execute() throws IOException, TooManyRequestsException {
        return LedgersRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public LedgersRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public LedgersRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public LedgersRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

