/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;

public class AccountResponse
extends Response
implements TransactionBuilderAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="account_id")
    private String accountId;
    @SerializedName(value="sequence")
    private Long sequenceNumber;
    @SerializedName(value="sequence_ledger")
    private Long sequenceUpdatedAtLedger;
    @SerializedName(value="sequence_time")
    private Long sequenceUpdatedAtTime;
    @SerializedName(value="subentry_count")
    private Integer subentryCount;
    @SerializedName(value="inflation_destination")
    private String inflationDestination;
    @SerializedName(value="home_domain")
    private String homeDomain;
    @SerializedName(value="last_modified_ledger")
    private Integer lastModifiedLedger;
    @SerializedName(value="last_modified_time")
    private String lastModifiedTime;
    @SerializedName(value="thresholds")
    private Thresholds thresholds;
    @SerializedName(value="flags")
    private Flags flags;
    @SerializedName(value="balances")
    private Balance[] balances;
    @SerializedName(value="signers")
    private Signer[] signers;
    @SerializedName(value="data")
    private Data data;
    @SerializedName(value="num_sponsoring")
    private Integer numSponsoring;
    @SerializedName(value="num_sponsored")
    private Integer numSponsored;
    @SerializedName(value="sponsor")
    private String sponsor;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="_links")
    private Links links;

    AccountResponse(String accountId) {
        this.accountId = accountId;
    }

    public AccountResponse(String accountId, Long sequenceNumber) {
        this.accountId = accountId;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public KeyPair getKeyPair() {
        return KeyPair.fromAccountId(this.accountId);
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNumber(long seqNum) {
        this.sequenceNumber = seqNum;
    }

    @Override
    public Long getIncrementedSequenceNumber() {
        return this.sequenceNumber + 1L;
    }

    @Override
    public void incrementSequenceNumber() {
        Long l = this.sequenceNumber;
        this.sequenceNumber = this.sequenceNumber + 1L;
    }

    public Optional<String> getSponsor() {
        return Optional.ofNullable(this.sponsor);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Long getSequenceUpdatedAtLedger() {
        return this.sequenceUpdatedAtLedger;
    }

    @Generated
    public Long getSequenceUpdatedAtTime() {
        return this.sequenceUpdatedAtTime;
    }

    @Generated
    public Integer getSubentryCount() {
        return this.subentryCount;
    }

    @Generated
    public String getInflationDestination() {
        return this.inflationDestination;
    }

    @Generated
    public String getHomeDomain() {
        return this.homeDomain;
    }

    @Generated
    public Integer getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    @Generated
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @Generated
    public Flags getFlags() {
        return this.flags;
    }

    @Generated
    public Balance[] getBalances() {
        return this.balances;
    }

    @Generated
    public Signer[] getSigners() {
        return this.signers;
    }

    @Generated
    public Data getData() {
        return this.data;
    }

    @Generated
    public Integer getNumSponsoring() {
        return this.numSponsoring;
    }

    @Generated
    public Integer getNumSponsored() {
        return this.numSponsored;
    }

    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountResponse)) {
            return false;
        }
        AccountResponse other = (AccountResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sequenceNumber = this.getSequenceNumber();
        Long other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber)) {
            return false;
        }
        Long this$sequenceUpdatedAtLedger = this.getSequenceUpdatedAtLedger();
        Long other$sequenceUpdatedAtLedger = other.getSequenceUpdatedAtLedger();
        if (this$sequenceUpdatedAtLedger == null ? other$sequenceUpdatedAtLedger != null : !((Object)this$sequenceUpdatedAtLedger).equals(other$sequenceUpdatedAtLedger)) {
            return false;
        }
        Long this$sequenceUpdatedAtTime = this.getSequenceUpdatedAtTime();
        Long other$sequenceUpdatedAtTime = other.getSequenceUpdatedAtTime();
        if (this$sequenceUpdatedAtTime == null ? other$sequenceUpdatedAtTime != null : !((Object)this$sequenceUpdatedAtTime).equals(other$sequenceUpdatedAtTime)) {
            return false;
        }
        Integer this$subentryCount = this.getSubentryCount();
        Integer other$subentryCount = other.getSubentryCount();
        if (this$subentryCount == null ? other$subentryCount != null : !((Object)this$subentryCount).equals(other$subentryCount)) {
            return false;
        }
        Integer this$lastModifiedLedger = this.getLastModifiedLedger();
        Integer other$lastModifiedLedger = other.getLastModifiedLedger();
        if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
            return false;
        }
        Integer this$numSponsoring = this.getNumSponsoring();
        Integer other$numSponsoring = other.getNumSponsoring();
        if (this$numSponsoring == null ? other$numSponsoring != null : !((Object)this$numSponsoring).equals(other$numSponsoring)) {
            return false;
        }
        Integer this$numSponsored = this.getNumSponsored();
        Integer other$numSponsored = other.getNumSponsored();
        if (this$numSponsored == null ? other$numSponsored != null : !((Object)this$numSponsored).equals(other$numSponsored)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$inflationDestination = this.getInflationDestination();
        String other$inflationDestination = other.getInflationDestination();
        if (this$inflationDestination == null ? other$inflationDestination != null : !this$inflationDestination.equals(other$inflationDestination)) {
            return false;
        }
        String this$homeDomain = this.getHomeDomain();
        String other$homeDomain = other.getHomeDomain();
        if (this$homeDomain == null ? other$homeDomain != null : !this$homeDomain.equals(other$homeDomain)) {
            return false;
        }
        String this$lastModifiedTime = this.getLastModifiedTime();
        String other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !this$lastModifiedTime.equals(other$lastModifiedTime)) {
            return false;
        }
        Thresholds this$thresholds = this.getThresholds();
        Thresholds other$thresholds = other.getThresholds();
        if (this$thresholds == null ? other$thresholds != null : !((Object)this$thresholds).equals(other$thresholds)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBalances(), other.getBalances())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSigners(), other.getSigners())) {
            return false;
        }
        Data this$data = this.getData();
        Data other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Optional<String> this$sponsor = this.getSponsor();
        Optional<String> other$sponsor = other.getSponsor();
        if (this$sponsor == null ? other$sponsor != null : !((Object)this$sponsor).equals(other$sponsor)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        Long $sequenceUpdatedAtLedger = this.getSequenceUpdatedAtLedger();
        result = result * 59 + ($sequenceUpdatedAtLedger == null ? 43 : ((Object)$sequenceUpdatedAtLedger).hashCode());
        Long $sequenceUpdatedAtTime = this.getSequenceUpdatedAtTime();
        result = result * 59 + ($sequenceUpdatedAtTime == null ? 43 : ((Object)$sequenceUpdatedAtTime).hashCode());
        Integer $subentryCount = this.getSubentryCount();
        result = result * 59 + ($subentryCount == null ? 43 : ((Object)$subentryCount).hashCode());
        Integer $lastModifiedLedger = this.getLastModifiedLedger();
        result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
        Integer $numSponsoring = this.getNumSponsoring();
        result = result * 59 + ($numSponsoring == null ? 43 : ((Object)$numSponsoring).hashCode());
        Integer $numSponsored = this.getNumSponsored();
        result = result * 59 + ($numSponsored == null ? 43 : ((Object)$numSponsored).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $inflationDestination = this.getInflationDestination();
        result = result * 59 + ($inflationDestination == null ? 43 : $inflationDestination.hashCode());
        String $homeDomain = this.getHomeDomain();
        result = result * 59 + ($homeDomain == null ? 43 : $homeDomain.hashCode());
        String $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : $lastModifiedTime.hashCode());
        Thresholds $thresholds = this.getThresholds();
        result = result * 59 + ($thresholds == null ? 43 : ((Object)$thresholds).hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBalances());
        result = result * 59 + Arrays.deepHashCode(this.getSigners());
        Data $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Optional<String> $sponsor = this.getSponsor();
        result = result * 59 + ($sponsor == null ? 43 : ((Object)$sponsor).hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Thresholds {
        @SerializedName(value="low_threshold")
        private final int lowThreshold;
        @SerializedName(value="med_threshold")
        private final int medThreshold;
        @SerializedName(value="high_threshold")
        private final int highThreshold;

        @Generated
        public Thresholds(int lowThreshold, int medThreshold, int highThreshold) {
            this.lowThreshold = lowThreshold;
            this.medThreshold = medThreshold;
            this.highThreshold = highThreshold;
        }

        @Generated
        public int getLowThreshold() {
            return this.lowThreshold;
        }

        @Generated
        public int getMedThreshold() {
            return this.medThreshold;
        }

        @Generated
        public int getHighThreshold() {
            return this.highThreshold;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Thresholds)) {
                return false;
            }
            Thresholds other = (Thresholds)o;
            if (this.getLowThreshold() != other.getLowThreshold()) {
                return false;
            }
            if (this.getMedThreshold() != other.getMedThreshold()) {
                return false;
            }
            return this.getHighThreshold() == other.getHighThreshold();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLowThreshold();
            result = result * 59 + this.getMedThreshold();
            result = result * 59 + this.getHighThreshold();
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Thresholds(lowThreshold=" + this.getLowThreshold() + ", medThreshold=" + this.getMedThreshold() + ", highThreshold=" + this.getHighThreshold() + ")";
        }
    }

    public static class Flags {
        @SerializedName(value="auth_required")
        private final boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final boolean authRevocable;
        @SerializedName(value="auth_immutable")
        private final boolean authImmutable;
        @SerializedName(value="auth_clawback_enabled")
        private final boolean authClawbackEnabled;

        public boolean getAuthRequired() {
            return this.authRequired;
        }

        public boolean getAuthRevocable() {
            return this.authRevocable;
        }

        public boolean getAuthImmutable() {
            return this.authImmutable;
        }

        public boolean getAuthClawbackEnabled() {
            return this.authClawbackEnabled;
        }

        @Generated
        public Flags(boolean authRequired, boolean authRevocable, boolean authImmutable, boolean authClawbackEnabled) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
            this.authImmutable = authImmutable;
            this.authClawbackEnabled = authClawbackEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags other = (Flags)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAuthRequired() != other.getAuthRequired()) {
                return false;
            }
            if (this.getAuthRevocable() != other.getAuthRevocable()) {
                return false;
            }
            if (this.getAuthImmutable() != other.getAuthImmutable()) {
                return false;
            }
            return this.getAuthClawbackEnabled() == other.getAuthClawbackEnabled();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Flags;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.getAuthRequired() ? 79 : 97);
            result = result * 59 + (this.getAuthRevocable() ? 79 : 97);
            result = result * 59 + (this.getAuthImmutable() ? 79 : 97);
            result = result * 59 + (this.getAuthClawbackEnabled() ? 79 : 97);
            return result;
        }
    }

    public static final class Balance {
        @SerializedName(value="asset_type")
        private final String assetType;
        @SerializedName(value="asset_code")
        private final String assetCode;
        @SerializedName(value="asset_issuer")
        private final String assetIssuer;
        @SerializedName(value="liquidity_pool_id")
        private final LiquidityPoolID liquidityPoolID;
        @SerializedName(value="limit")
        private final String limit;
        @SerializedName(value="balance")
        private final String balance;
        @SerializedName(value="buying_liabilities")
        private final String buyingLiabilities;
        @SerializedName(value="selling_liabilities")
        private final String sellingLiabilities;
        @SerializedName(value="is_authorized")
        private final Boolean isAuthorized;
        @SerializedName(value="is_authorized_to_maintain_liabilities")
        private final Boolean isAuthorizedToMaintainLiabilities;
        @SerializedName(value="is_clawback_enabled")
        private final Boolean isClawbackEnabled;
        @SerializedName(value="last_modified_ledger")
        private final Integer lastModifiedLedger;
        @SerializedName(value="sponsor")
        private final String sponsor;

        public Optional<Asset> getAsset() {
            if (this.liquidityPoolID != null) {
                return Optional.of(Asset.create(this.assetType, this.assetCode, this.assetIssuer, this.liquidityPoolID.toString()));
            }
            return Optional.of(Asset.create(this.assetType, this.assetCode, this.assetIssuer));
        }

        public Optional<String> getAssetCode() {
            return Optional.ofNullable(this.assetCode);
        }

        public Optional<String> getAssetIssuer() {
            return Optional.ofNullable(this.assetIssuer);
        }

        public Optional<LiquidityPoolID> getLiquidityPoolID() {
            return Optional.ofNullable(this.liquidityPoolID);
        }

        public Optional<String> getBuyingLiabilities() {
            return Optional.ofNullable(this.buyingLiabilities);
        }

        public Optional<String> getSellingLiabilities() {
            return Optional.ofNullable(this.sellingLiabilities);
        }

        public Boolean getAuthorized() {
            return this.isAuthorized;
        }

        public Boolean getAuthorizedToMaintainLiabilities() {
            return this.isAuthorizedToMaintainLiabilities;
        }

        public Boolean getClawbackEnabled() {
            return this.isClawbackEnabled;
        }

        public Optional<String> getSponsor() {
            return Optional.ofNullable(this.sponsor);
        }

        @Generated
        public Balance(String assetType, String assetCode, String assetIssuer, LiquidityPoolID liquidityPoolID, String limit, String balance, String buyingLiabilities, String sellingLiabilities, Boolean isAuthorized, Boolean isAuthorizedToMaintainLiabilities, Boolean isClawbackEnabled, Integer lastModifiedLedger, String sponsor) {
            this.assetType = assetType;
            this.assetCode = assetCode;
            this.assetIssuer = assetIssuer;
            this.liquidityPoolID = liquidityPoolID;
            this.limit = limit;
            this.balance = balance;
            this.buyingLiabilities = buyingLiabilities;
            this.sellingLiabilities = sellingLiabilities;
            this.isAuthorized = isAuthorized;
            this.isAuthorizedToMaintainLiabilities = isAuthorizedToMaintainLiabilities;
            this.isClawbackEnabled = isClawbackEnabled;
            this.lastModifiedLedger = lastModifiedLedger;
            this.sponsor = sponsor;
        }

        @Generated
        public String getAssetType() {
            return this.assetType;
        }

        @Generated
        public String getLimit() {
            return this.limit;
        }

        @Generated
        public String getBalance() {
            return this.balance;
        }

        @Generated
        public Boolean getIsAuthorized() {
            return this.isAuthorized;
        }

        @Generated
        public Boolean getIsAuthorizedToMaintainLiabilities() {
            return this.isAuthorizedToMaintainLiabilities;
        }

        @Generated
        public Boolean getIsClawbackEnabled() {
            return this.isClawbackEnabled;
        }

        @Generated
        public Integer getLastModifiedLedger() {
            return this.lastModifiedLedger;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance other = (Balance)o;
            Boolean this$isAuthorized = this.getIsAuthorized();
            Boolean other$isAuthorized = other.getIsAuthorized();
            if (this$isAuthorized == null ? other$isAuthorized != null : !((Object)this$isAuthorized).equals(other$isAuthorized)) {
                return false;
            }
            Boolean this$isAuthorizedToMaintainLiabilities = this.getIsAuthorizedToMaintainLiabilities();
            Boolean other$isAuthorizedToMaintainLiabilities = other.getIsAuthorizedToMaintainLiabilities();
            if (this$isAuthorizedToMaintainLiabilities == null ? other$isAuthorizedToMaintainLiabilities != null : !((Object)this$isAuthorizedToMaintainLiabilities).equals(other$isAuthorizedToMaintainLiabilities)) {
                return false;
            }
            Boolean this$isClawbackEnabled = this.getIsClawbackEnabled();
            Boolean other$isClawbackEnabled = other.getIsClawbackEnabled();
            if (this$isClawbackEnabled == null ? other$isClawbackEnabled != null : !((Object)this$isClawbackEnabled).equals(other$isClawbackEnabled)) {
                return false;
            }
            Integer this$lastModifiedLedger = this.getLastModifiedLedger();
            Integer other$lastModifiedLedger = other.getLastModifiedLedger();
            if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
                return false;
            }
            String this$assetType = this.getAssetType();
            String other$assetType = other.getAssetType();
            if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
                return false;
            }
            Optional<String> this$assetCode = this.getAssetCode();
            Optional<String> other$assetCode = other.getAssetCode();
            if (this$assetCode == null ? other$assetCode != null : !((Object)this$assetCode).equals(other$assetCode)) {
                return false;
            }
            Optional<String> this$assetIssuer = this.getAssetIssuer();
            Optional<String> other$assetIssuer = other.getAssetIssuer();
            if (this$assetIssuer == null ? other$assetIssuer != null : !((Object)this$assetIssuer).equals(other$assetIssuer)) {
                return false;
            }
            Optional<LiquidityPoolID> this$liquidityPoolID = this.getLiquidityPoolID();
            Optional<LiquidityPoolID> other$liquidityPoolID = other.getLiquidityPoolID();
            if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
                return false;
            }
            String this$limit = this.getLimit();
            String other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !this$limit.equals(other$limit)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            Optional<String> this$buyingLiabilities = this.getBuyingLiabilities();
            Optional<String> other$buyingLiabilities = other.getBuyingLiabilities();
            if (this$buyingLiabilities == null ? other$buyingLiabilities != null : !((Object)this$buyingLiabilities).equals(other$buyingLiabilities)) {
                return false;
            }
            Optional<String> this$sellingLiabilities = this.getSellingLiabilities();
            Optional<String> other$sellingLiabilities = other.getSellingLiabilities();
            if (this$sellingLiabilities == null ? other$sellingLiabilities != null : !((Object)this$sellingLiabilities).equals(other$sellingLiabilities)) {
                return false;
            }
            Optional<String> this$sponsor = this.getSponsor();
            Optional<String> other$sponsor = other.getSponsor();
            return !(this$sponsor == null ? other$sponsor != null : !((Object)this$sponsor).equals(other$sponsor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isAuthorized = this.getIsAuthorized();
            result = result * 59 + ($isAuthorized == null ? 43 : ((Object)$isAuthorized).hashCode());
            Boolean $isAuthorizedToMaintainLiabilities = this.getIsAuthorizedToMaintainLiabilities();
            result = result * 59 + ($isAuthorizedToMaintainLiabilities == null ? 43 : ((Object)$isAuthorizedToMaintainLiabilities).hashCode());
            Boolean $isClawbackEnabled = this.getIsClawbackEnabled();
            result = result * 59 + ($isClawbackEnabled == null ? 43 : ((Object)$isClawbackEnabled).hashCode());
            Integer $lastModifiedLedger = this.getLastModifiedLedger();
            result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
            String $assetType = this.getAssetType();
            result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
            Optional<String> $assetCode = this.getAssetCode();
            result = result * 59 + ($assetCode == null ? 43 : ((Object)$assetCode).hashCode());
            Optional<String> $assetIssuer = this.getAssetIssuer();
            result = result * 59 + ($assetIssuer == null ? 43 : ((Object)$assetIssuer).hashCode());
            Optional<LiquidityPoolID> $liquidityPoolID = this.getLiquidityPoolID();
            result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
            String $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : $limit.hashCode());
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            Optional<String> $buyingLiabilities = this.getBuyingLiabilities();
            result = result * 59 + ($buyingLiabilities == null ? 43 : ((Object)$buyingLiabilities).hashCode());
            Optional<String> $sellingLiabilities = this.getSellingLiabilities();
            result = result * 59 + ($sellingLiabilities == null ? 43 : ((Object)$sellingLiabilities).hashCode());
            Optional<String> $sponsor = this.getSponsor();
            result = result * 59 + ($sponsor == null ? 43 : ((Object)$sponsor).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Balance(assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", liquidityPoolID=" + this.getLiquidityPoolID() + ", limit=" + this.getLimit() + ", balance=" + this.getBalance() + ", buyingLiabilities=" + this.getBuyingLiabilities() + ", sellingLiabilities=" + this.getSellingLiabilities() + ", isAuthorized=" + this.getIsAuthorized() + ", isAuthorizedToMaintainLiabilities=" + this.getIsAuthorizedToMaintainLiabilities() + ", isClawbackEnabled=" + this.getIsClawbackEnabled() + ", lastModifiedLedger=" + this.getLastModifiedLedger() + ", sponsor=" + this.getSponsor() + ")";
        }
    }

    public static final class Signer {
        @SerializedName(value="key")
        private final String key;
        @SerializedName(value="type")
        private final String type;
        @SerializedName(value="weight")
        private final int weight;
        @SerializedName(value="sponsor")
        private final String sponsor;

        public Optional<String> getSponsor() {
            return Optional.ofNullable(this.sponsor);
        }

        @Generated
        public Signer(String key, String type, int weight, String sponsor) {
            this.key = key;
            this.type = type;
            this.weight = weight;
            this.sponsor = sponsor;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public int getWeight() {
            return this.weight;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signer)) {
                return false;
            }
            Signer other = (Signer)o;
            if (this.getWeight() != other.getWeight()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Optional<String> this$sponsor = this.getSponsor();
            Optional<String> other$sponsor = other.getSponsor();
            return !(this$sponsor == null ? other$sponsor != null : !((Object)this$sponsor).equals(other$sponsor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWeight();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Optional<String> $sponsor = this.getSponsor();
            result = result * 59 + ($sponsor == null ? 43 : ((Object)$sponsor).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Signer(key=" + this.getKey() + ", type=" + this.getType() + ", weight=" + this.getWeight() + ", sponsor=" + this.getSponsor() + ")";
        }
    }

    public static class Data
    extends HashMap<String, String> {
        @Override
        public int size() {
            return super.size();
        }

        public String get(String key) {
            return (String)super.get(key);
        }

        public byte[] getDecoded(String key) {
            return Base64Factory.getInstance().decode(this.get(key));
        }
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="payments")
        private final Link payments;
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="offers")
        private final Link offers;
        @SerializedName(value="trades")
        private final Link trades;
        @SerializedName(value="data")
        private final Link data;

        @Generated
        public Links(Link self, Link transactions, Link operations, Link payments, Link effects, Link offers, Link trades, Link data) {
            this.self = self;
            this.transactions = transactions;
            this.operations = operations;
            this.payments = payments;
            this.effects = effects;
            this.offers = offers;
            this.trades = trades;
            this.data = data;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getTransactions() {
            return this.transactions;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public Link getPayments() {
            return this.payments;
        }

        @Generated
        public Link getEffects() {
            return this.effects;
        }

        @Generated
        public Link getOffers() {
            return this.offers;
        }

        @Generated
        public Link getTrades() {
            return this.trades;
        }

        @Generated
        public Link getData() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$transactions = this.getTransactions();
            Link other$transactions = other.getTransactions();
            if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Link this$payments = this.getPayments();
            Link other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            Link this$effects = this.getEffects();
            Link other$effects = other.getEffects();
            if (this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects)) {
                return false;
            }
            Link this$offers = this.getOffers();
            Link other$offers = other.getOffers();
            if (this$offers == null ? other$offers != null : !((Object)this$offers).equals(other$offers)) {
                return false;
            }
            Link this$trades = this.getTrades();
            Link other$trades = other.getTrades();
            if (this$trades == null ? other$trades != null : !((Object)this$trades).equals(other$trades)) {
                return false;
            }
            Link this$data = this.getData();
            Link other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Link $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            Link $effects = this.getEffects();
            result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
            Link $offers = this.getOffers();
            result = result * 59 + ($offers == null ? 43 : ((Object)$offers).hashCode());
            Link $trades = this.getTrades();
            result = result * 59 + ($trades == null ? 43 : ((Object)$trades).hashCode());
            Link $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Links(self=" + this.getSelf() + ", transactions=" + this.getTransactions() + ", operations=" + this.getOperations() + ", payments=" + this.getPayments() + ", effects=" + this.getEffects() + ", offers=" + this.getOffers() + ", trades=" + this.getTrades() + ", data=" + this.getData() + ")";
        }
    }
}

