/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.effects.EffectResponse;

public final class TradeEffectResponse
extends EffectResponse {
    @SerializedName(value="seller")
    private final String seller;
    @SerializedName(value="seller_muxed")
    private final String sellerMuxed;
    @SerializedName(value="seller_muxed_id")
    private final BigInteger sellerMuxedId;
    @SerializedName(value="offer_id")
    private final Long offerId;
    @SerializedName(value="sold_amount")
    private final String soldAmount;
    @SerializedName(value="sold_asset_type")
    private final String soldAssetType;
    @SerializedName(value="sold_asset_code")
    private final String soldAssetCode;
    @SerializedName(value="sold_asset_issuer")
    private final String soldAssetIssuer;
    @SerializedName(value="bought_amount")
    private final String boughtAmount;
    @SerializedName(value="bought_asset_type")
    private final String boughtAssetType;
    @SerializedName(value="bought_asset_code")
    private final String boughtAssetCode;
    @SerializedName(value="bought_asset_issuer")
    private final String boughtAssetIssuer;

    public Optional<MuxedAccount> getSellerMuxed() {
        if (this.sellerMuxed == null || this.sellerMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.sellerMuxed, this.seller, this.sellerMuxedId));
    }

    public Asset getSoldAsset() {
        return Asset.create(this.soldAssetType, this.soldAssetCode, this.soldAssetIssuer);
    }

    public Asset getBoughtAsset() {
        return Asset.create(this.boughtAssetType, this.boughtAssetCode, this.boughtAssetIssuer);
    }

    @Generated
    public TradeEffectResponse(String seller, String sellerMuxed, BigInteger sellerMuxedId, Long offerId, String soldAmount, String soldAssetType, String soldAssetCode, String soldAssetIssuer, String boughtAmount, String boughtAssetType, String boughtAssetCode, String boughtAssetIssuer) {
        this.seller = seller;
        this.sellerMuxed = sellerMuxed;
        this.sellerMuxedId = sellerMuxedId;
        this.offerId = offerId;
        this.soldAmount = soldAmount;
        this.soldAssetType = soldAssetType;
        this.soldAssetCode = soldAssetCode;
        this.soldAssetIssuer = soldAssetIssuer;
        this.boughtAmount = boughtAmount;
        this.boughtAssetType = boughtAssetType;
        this.boughtAssetCode = boughtAssetCode;
        this.boughtAssetIssuer = boughtAssetIssuer;
    }

    @Generated
    public String getSeller() {
        return this.seller;
    }

    @Generated
    public BigInteger getSellerMuxedId() {
        return this.sellerMuxedId;
    }

    @Generated
    public Long getOfferId() {
        return this.offerId;
    }

    @Generated
    public String getSoldAmount() {
        return this.soldAmount;
    }

    @Generated
    public String getSoldAssetType() {
        return this.soldAssetType;
    }

    @Generated
    public String getSoldAssetCode() {
        return this.soldAssetCode;
    }

    @Generated
    public String getSoldAssetIssuer() {
        return this.soldAssetIssuer;
    }

    @Generated
    public String getBoughtAmount() {
        return this.boughtAmount;
    }

    @Generated
    public String getBoughtAssetType() {
        return this.boughtAssetType;
    }

    @Generated
    public String getBoughtAssetCode() {
        return this.boughtAssetCode;
    }

    @Generated
    public String getBoughtAssetIssuer() {
        return this.boughtAssetIssuer;
    }

    @Generated
    public String toString() {
        return "TradeEffectResponse(seller=" + this.getSeller() + ", sellerMuxed=" + this.getSellerMuxed() + ", sellerMuxedId=" + this.getSellerMuxedId() + ", offerId=" + this.getOfferId() + ", soldAmount=" + this.getSoldAmount() + ", soldAssetType=" + this.getSoldAssetType() + ", soldAssetCode=" + this.getSoldAssetCode() + ", soldAssetIssuer=" + this.getSoldAssetIssuer() + ", boughtAmount=" + this.getBoughtAmount() + ", boughtAssetType=" + this.getBoughtAssetType() + ", boughtAssetCode=" + this.getBoughtAssetCode() + ", boughtAssetIssuer=" + this.getBoughtAssetIssuer() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeEffectResponse)) {
            return false;
        }
        TradeEffectResponse other = (TradeEffectResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$offerId = this.getOfferId();
        Long other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !((Object)this$offerId).equals(other$offerId)) {
            return false;
        }
        String this$seller = this.getSeller();
        String other$seller = other.getSeller();
        if (this$seller == null ? other$seller != null : !this$seller.equals(other$seller)) {
            return false;
        }
        Optional<MuxedAccount> this$sellerMuxed = this.getSellerMuxed();
        Optional<MuxedAccount> other$sellerMuxed = other.getSellerMuxed();
        if (this$sellerMuxed == null ? other$sellerMuxed != null : !((Object)this$sellerMuxed).equals(other$sellerMuxed)) {
            return false;
        }
        BigInteger this$sellerMuxedId = this.getSellerMuxedId();
        BigInteger other$sellerMuxedId = other.getSellerMuxedId();
        if (this$sellerMuxedId == null ? other$sellerMuxedId != null : !((Object)this$sellerMuxedId).equals(other$sellerMuxedId)) {
            return false;
        }
        String this$soldAmount = this.getSoldAmount();
        String other$soldAmount = other.getSoldAmount();
        if (this$soldAmount == null ? other$soldAmount != null : !this$soldAmount.equals(other$soldAmount)) {
            return false;
        }
        String this$soldAssetType = this.getSoldAssetType();
        String other$soldAssetType = other.getSoldAssetType();
        if (this$soldAssetType == null ? other$soldAssetType != null : !this$soldAssetType.equals(other$soldAssetType)) {
            return false;
        }
        String this$soldAssetCode = this.getSoldAssetCode();
        String other$soldAssetCode = other.getSoldAssetCode();
        if (this$soldAssetCode == null ? other$soldAssetCode != null : !this$soldAssetCode.equals(other$soldAssetCode)) {
            return false;
        }
        String this$soldAssetIssuer = this.getSoldAssetIssuer();
        String other$soldAssetIssuer = other.getSoldAssetIssuer();
        if (this$soldAssetIssuer == null ? other$soldAssetIssuer != null : !this$soldAssetIssuer.equals(other$soldAssetIssuer)) {
            return false;
        }
        String this$boughtAmount = this.getBoughtAmount();
        String other$boughtAmount = other.getBoughtAmount();
        if (this$boughtAmount == null ? other$boughtAmount != null : !this$boughtAmount.equals(other$boughtAmount)) {
            return false;
        }
        String this$boughtAssetType = this.getBoughtAssetType();
        String other$boughtAssetType = other.getBoughtAssetType();
        if (this$boughtAssetType == null ? other$boughtAssetType != null : !this$boughtAssetType.equals(other$boughtAssetType)) {
            return false;
        }
        String this$boughtAssetCode = this.getBoughtAssetCode();
        String other$boughtAssetCode = other.getBoughtAssetCode();
        if (this$boughtAssetCode == null ? other$boughtAssetCode != null : !this$boughtAssetCode.equals(other$boughtAssetCode)) {
            return false;
        }
        String this$boughtAssetIssuer = this.getBoughtAssetIssuer();
        String other$boughtAssetIssuer = other.getBoughtAssetIssuer();
        return !(this$boughtAssetIssuer == null ? other$boughtAssetIssuer != null : !this$boughtAssetIssuer.equals(other$boughtAssetIssuer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TradeEffectResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : ((Object)$offerId).hashCode());
        String $seller = this.getSeller();
        result = result * 59 + ($seller == null ? 43 : $seller.hashCode());
        Optional<MuxedAccount> $sellerMuxed = this.getSellerMuxed();
        result = result * 59 + ($sellerMuxed == null ? 43 : ((Object)$sellerMuxed).hashCode());
        BigInteger $sellerMuxedId = this.getSellerMuxedId();
        result = result * 59 + ($sellerMuxedId == null ? 43 : ((Object)$sellerMuxedId).hashCode());
        String $soldAmount = this.getSoldAmount();
        result = result * 59 + ($soldAmount == null ? 43 : $soldAmount.hashCode());
        String $soldAssetType = this.getSoldAssetType();
        result = result * 59 + ($soldAssetType == null ? 43 : $soldAssetType.hashCode());
        String $soldAssetCode = this.getSoldAssetCode();
        result = result * 59 + ($soldAssetCode == null ? 43 : $soldAssetCode.hashCode());
        String $soldAssetIssuer = this.getSoldAssetIssuer();
        result = result * 59 + ($soldAssetIssuer == null ? 43 : $soldAssetIssuer.hashCode());
        String $boughtAmount = this.getBoughtAmount();
        result = result * 59 + ($boughtAmount == null ? 43 : $boughtAmount.hashCode());
        String $boughtAssetType = this.getBoughtAssetType();
        result = result * 59 + ($boughtAssetType == null ? 43 : $boughtAssetType.hashCode());
        String $boughtAssetCode = this.getBoughtAssetCode();
        result = result * 59 + ($boughtAssetCode == null ? 43 : $boughtAssetCode.hashCode());
        String $boughtAssetIssuer = this.getBoughtAssetIssuer();
        result = result * 59 + ($boughtAssetIssuer == null ? 43 : $boughtAssetIssuer.hashCode());
        return result;
    }
}

