/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.MuxedAccount;
import org.stellar.sdk.responses.operations.OperationResponse;

public final class ChangeTrustOperationResponse
extends OperationResponse {
    @SerializedName(value="trustor")
    private final String trustor;
    @SerializedName(value="trustor_muxed")
    private final String trustorMuxed;
    @SerializedName(value="trustor_muxed_id")
    private final BigInteger trustorMuxedId;
    @SerializedName(value="trustee")
    private final String trustee;
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="limit")
    private final String limit;
    @SerializedName(value="liquidity_pool_id")
    private final String liquidityPoolId;

    public Optional<MuxedAccount> getTrustorMuxed() {
        if (this.trustorMuxed == null || this.trustorMuxed.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MuxedAccount(this.trustorMuxed, this.trustor, this.trustorMuxedId));
    }

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer, this.liquidityPoolId);
    }

    @Generated
    public ChangeTrustOperationResponse(String trustor, String trustorMuxed, BigInteger trustorMuxedId, String trustee, String assetType, String assetCode, String assetIssuer, String limit, String liquidityPoolId) {
        this.trustor = trustor;
        this.trustorMuxed = trustorMuxed;
        this.trustorMuxedId = trustorMuxedId;
        this.trustee = trustee;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.limit = limit;
        this.liquidityPoolId = liquidityPoolId;
    }

    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @Generated
    public BigInteger getTrustorMuxedId() {
        return this.trustorMuxedId;
    }

    @Generated
    public String getTrustee() {
        return this.trustee;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public String getLimit() {
        return this.limit;
    }

    @Generated
    public String getLiquidityPoolId() {
        return this.liquidityPoolId;
    }

    @Generated
    public String toString() {
        return "ChangeTrustOperationResponse(trustor=" + this.getTrustor() + ", trustorMuxed=" + this.getTrustorMuxed() + ", trustorMuxedId=" + this.getTrustorMuxedId() + ", trustee=" + this.getTrustee() + ", assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", limit=" + this.getLimit() + ", liquidityPoolId=" + this.getLiquidityPoolId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTrustOperationResponse)) {
            return false;
        }
        ChangeTrustOperationResponse other = (ChangeTrustOperationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        Optional<MuxedAccount> this$trustorMuxed = this.getTrustorMuxed();
        Optional<MuxedAccount> other$trustorMuxed = other.getTrustorMuxed();
        if (this$trustorMuxed == null ? other$trustorMuxed != null : !((Object)this$trustorMuxed).equals(other$trustorMuxed)) {
            return false;
        }
        BigInteger this$trustorMuxedId = this.getTrustorMuxedId();
        BigInteger other$trustorMuxedId = other.getTrustorMuxedId();
        if (this$trustorMuxedId == null ? other$trustorMuxedId != null : !((Object)this$trustorMuxedId).equals(other$trustorMuxedId)) {
            return false;
        }
        String this$trustee = this.getTrustee();
        String other$trustee = other.getTrustee();
        if (this$trustee == null ? other$trustee != null : !this$trustee.equals(other$trustee)) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
            return false;
        }
        String this$limit = this.getLimit();
        String other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !this$limit.equals(other$limit)) {
            return false;
        }
        String this$liquidityPoolId = this.getLiquidityPoolId();
        String other$liquidityPoolId = other.getLiquidityPoolId();
        return !(this$liquidityPoolId == null ? other$liquidityPoolId != null : !this$liquidityPoolId.equals(other$liquidityPoolId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeTrustOperationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        Optional<MuxedAccount> $trustorMuxed = this.getTrustorMuxed();
        result = result * 59 + ($trustorMuxed == null ? 43 : ((Object)$trustorMuxed).hashCode());
        BigInteger $trustorMuxedId = this.getTrustorMuxedId();
        result = result * 59 + ($trustorMuxedId == null ? 43 : ((Object)$trustorMuxedId).hashCode());
        String $trustee = this.getTrustee();
        result = result * 59 + ($trustee == null ? 43 : $trustee.hashCode());
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        String $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : $limit.hashCode());
        String $liquidityPoolId = this.getLiquidityPoolId();
        result = result * 59 + ($liquidityPoolId == null ? 43 : $liquidityPoolId.hashCode());
        return result;
    }
}

