/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.scval;

import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SCValType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

class ScvUint32 {
    private static final SCValType TYPE = SCValType.SCV_U32;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final long MIN_VALUE = 0L;

    ScvUint32() {
    }

    static SCVal toSCVal(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("invalid value, expected between %s and %s, but got %s", 0L, 0xFFFFFFFFL, value));
        }
        return new SCVal.Builder().discriminant(TYPE).u32(new Uint32(new XdrUnsignedInteger(value))).build();
    }

    static long fromSCVal(SCVal scVal) {
        if (scVal.getDiscriminant() != TYPE) {
            throw new IllegalArgumentException(String.format("invalid scVal type, expected %s, but got %s", TYPE, scVal.getDiscriminant()));
        }
        return scVal.getU32().getUint32().getNumber();
    }
}

