/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntryExtensionV3
implements XdrElement {
    private ExtensionPoint ext;
    private Uint32 seqLedger;
    private TimePoint seqTime;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Uint32 getSeqLedger() {
        return this.seqLedger;
    }

    public void setSeqLedger(Uint32 value) {
        this.seqLedger = value;
    }

    public TimePoint getSeqTime() {
        return this.seqTime;
    }

    public void setSeqTime(TimePoint value) {
        this.seqTime = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountEntryExtensionV3 encodedAccountEntryExtensionV3) throws IOException {
        ExtensionPoint.encode(stream, encodedAccountEntryExtensionV3.ext);
        Uint32.encode(stream, encodedAccountEntryExtensionV3.seqLedger);
        TimePoint.encode(stream, encodedAccountEntryExtensionV3.seqTime);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountEntryExtensionV3.encode(stream, this);
    }

    public static AccountEntryExtensionV3 decode(XdrDataInputStream stream) throws IOException {
        AccountEntryExtensionV3 decodedAccountEntryExtensionV3 = new AccountEntryExtensionV3();
        decodedAccountEntryExtensionV3.ext = ExtensionPoint.decode(stream);
        decodedAccountEntryExtensionV3.seqLedger = Uint32.decode(stream);
        decodedAccountEntryExtensionV3.seqTime = TimePoint.decode(stream);
        return decodedAccountEntryExtensionV3;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.seqLedger, this.seqTime);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountEntryExtensionV3)) {
            return false;
        }
        AccountEntryExtensionV3 other = (AccountEntryExtensionV3)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.seqLedger, other.seqLedger) && Objects.equals(this.seqTime, other.seqTime);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AccountEntryExtensionV3 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntryExtensionV3.fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV3 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntryExtensionV3.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Uint32 seqLedger;
        private TimePoint seqTime;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder seqLedger(Uint32 seqLedger) {
            this.seqLedger = seqLedger;
            return this;
        }

        public Builder seqTime(TimePoint seqTime) {
            this.seqTime = seqTime;
            return this;
        }

        public AccountEntryExtensionV3 build() {
            AccountEntryExtensionV3 val = new AccountEntryExtensionV3();
            val.setExt(this.ext);
            val.setSeqLedger(this.seqLedger);
            val.setSeqTime(this.seqTime);
            return val;
        }
    }
}

