/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AccountFlags implements XdrElement
{
    AUTH_REQUIRED_FLAG(1),
    AUTH_REVOCABLE_FLAG(2),
    AUTH_IMMUTABLE_FLAG(4),
    AUTH_CLAWBACK_ENABLED_FLAG(8);

    private int mValue;

    private AccountFlags(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static AccountFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return AUTH_REQUIRED_FLAG;
            }
            case 2: {
                return AUTH_REVOCABLE_FLAG;
            }
            case 4: {
                return AUTH_IMMUTABLE_FLAG;
            }
            case 8: {
                return AUTH_CLAWBACK_ENABLED_FLAG;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, AccountFlags value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountFlags.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AccountFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountFlags.fromXdrByteArray(bytes);
    }

    public static AccountFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountFlags.decode(xdrDataInputStream);
    }
}

