/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AlphaNum4
implements XdrElement {
    private AssetCode4 assetCode;
    private AccountID issuer;

    public AssetCode4 getAssetCode() {
        return this.assetCode;
    }

    public void setAssetCode(AssetCode4 value) {
        this.assetCode = value;
    }

    public AccountID getIssuer() {
        return this.issuer;
    }

    public void setIssuer(AccountID value) {
        this.issuer = value;
    }

    public static void encode(XdrDataOutputStream stream, AlphaNum4 encodedAlphaNum4) throws IOException {
        AssetCode4.encode(stream, encodedAlphaNum4.assetCode);
        AccountID.encode(stream, encodedAlphaNum4.issuer);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AlphaNum4.encode(stream, this);
    }

    public static AlphaNum4 decode(XdrDataInputStream stream) throws IOException {
        AlphaNum4 decodedAlphaNum4 = new AlphaNum4();
        decodedAlphaNum4.assetCode = AssetCode4.decode(stream);
        decodedAlphaNum4.issuer = AccountID.decode(stream);
        return decodedAlphaNum4;
    }

    public int hashCode() {
        return Objects.hash(this.assetCode, this.issuer);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlphaNum4)) {
            return false;
        }
        AlphaNum4 other = (AlphaNum4)object;
        return Objects.equals(this.assetCode, other.assetCode) && Objects.equals(this.issuer, other.issuer);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AlphaNum4 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AlphaNum4.fromXdrByteArray(bytes);
    }

    public static AlphaNum4 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AlphaNum4.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AssetCode4 assetCode;
        private AccountID issuer;

        public Builder assetCode(AssetCode4 assetCode) {
            this.assetCode = assetCode;
            return this;
        }

        public Builder issuer(AccountID issuer) {
            this.issuer = issuer;
            return this;
        }

        public AlphaNum4 build() {
            AlphaNum4 val = new AlphaNum4();
            val.setAssetCode(this.assetCode);
            val.setIssuer(this.issuer);
            return val;
        }
    }
}

