/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Asset
implements XdrElement {
    AssetType type;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;

    public AssetType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(AssetType value) {
        this.type = value;
    }

    public AlphaNum4 getAlphaNum4() {
        return this.alphaNum4;
    }

    public void setAlphaNum4(AlphaNum4 value) {
        this.alphaNum4 = value;
    }

    public AlphaNum12 getAlphaNum12() {
        return this.alphaNum12;
    }

    public void setAlphaNum12(AlphaNum12 value) {
        this.alphaNum12 = value;
    }

    public static void encode(XdrDataOutputStream stream, Asset encodedAsset) throws IOException {
        stream.writeInt(encodedAsset.getDiscriminant().getValue());
        switch (encodedAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                AlphaNum4.encode(stream, encodedAsset.alphaNum4);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                AlphaNum12.encode(stream, encodedAsset.alphaNum12);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Asset.encode(stream, this);
    }

    public static Asset decode(XdrDataInputStream stream) throws IOException {
        Asset decodedAsset = new Asset();
        AssetType discriminant = AssetType.decode(stream);
        decodedAsset.setDiscriminant(discriminant);
        switch (decodedAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedAsset.alphaNum4 = AlphaNum4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedAsset.alphaNum12 = AlphaNum12.decode(stream);
            }
        }
        return decodedAsset;
    }

    public int hashCode() {
        return Objects.hash(this.alphaNum4, this.alphaNum12, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)object;
        return Objects.equals(this.alphaNum4, other.alphaNum4) && Objects.equals(this.alphaNum12, other.alphaNum12) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Asset fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Asset.fromXdrByteArray(bytes);
    }

    public static Asset fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Asset.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AssetType discriminant;
        private AlphaNum4 alphaNum4;
        private AlphaNum12 alphaNum12;

        public Builder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder alphaNum4(AlphaNum4 alphaNum4) {
            this.alphaNum4 = alphaNum4;
            return this;
        }

        public Builder alphaNum12(AlphaNum12 alphaNum12) {
            this.alphaNum12 = alphaNum12;
            return this;
        }

        public Asset build() {
            Asset val = new Asset();
            val.setDiscriminant(this.discriminant);
            val.setAlphaNum4(this.alphaNum4);
            val.setAlphaNum12(this.alphaNum12);
            return val;
        }
    }
}

