/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.HmacSha256Mac;
import org.stellar.sdk.xdr.StellarMessage;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AuthenticatedMessage
implements XdrElement {
    Uint32 v;
    private AuthenticatedMessageV0 v0;

    public Uint32 getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Uint32 value) {
        this.v = value;
    }

    public AuthenticatedMessageV0 getV0() {
        return this.v0;
    }

    public void setV0(AuthenticatedMessageV0 value) {
        this.v0 = value;
    }

    public static void encode(XdrDataOutputStream stream, AuthenticatedMessage encodedAuthenticatedMessage) throws IOException {
        stream.writeInt(encodedAuthenticatedMessage.getDiscriminant().getUint32().getNumber().intValue());
        switch (encodedAuthenticatedMessage.getDiscriminant().getUint32().getNumber().intValue()) {
            case 0: {
                AuthenticatedMessageV0.encode(stream, encodedAuthenticatedMessage.v0);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AuthenticatedMessage.encode(stream, this);
    }

    public static AuthenticatedMessage decode(XdrDataInputStream stream) throws IOException {
        AuthenticatedMessage decodedAuthenticatedMessage = new AuthenticatedMessage();
        Uint32 discriminant = Uint32.decode(stream);
        decodedAuthenticatedMessage.setDiscriminant(discriminant);
        switch (decodedAuthenticatedMessage.getDiscriminant().getUint32().getNumber().intValue()) {
            case 0: {
                decodedAuthenticatedMessage.v0 = AuthenticatedMessageV0.decode(stream);
            }
        }
        return decodedAuthenticatedMessage;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AuthenticatedMessage)) {
            return false;
        }
        AuthenticatedMessage other = (AuthenticatedMessage)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AuthenticatedMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AuthenticatedMessage.fromXdrByteArray(bytes);
    }

    public static AuthenticatedMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AuthenticatedMessage.decode(xdrDataInputStream);
    }

    public static class AuthenticatedMessageV0
    implements XdrElement {
        private Uint64 sequence;
        private StellarMessage message;
        private HmacSha256Mac mac;

        public Uint64 getSequence() {
            return this.sequence;
        }

        public void setSequence(Uint64 value) {
            this.sequence = value;
        }

        public StellarMessage getMessage() {
            return this.message;
        }

        public void setMessage(StellarMessage value) {
            this.message = value;
        }

        public HmacSha256Mac getMac() {
            return this.mac;
        }

        public void setMac(HmacSha256Mac value) {
            this.mac = value;
        }

        public static void encode(XdrDataOutputStream stream, AuthenticatedMessageV0 encodedAuthenticatedMessageV0) throws IOException {
            Uint64.encode(stream, encodedAuthenticatedMessageV0.sequence);
            StellarMessage.encode(stream, encodedAuthenticatedMessageV0.message);
            HmacSha256Mac.encode(stream, encodedAuthenticatedMessageV0.mac);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            AuthenticatedMessageV0.encode(stream, this);
        }

        public static AuthenticatedMessageV0 decode(XdrDataInputStream stream) throws IOException {
            AuthenticatedMessageV0 decodedAuthenticatedMessageV0 = new AuthenticatedMessageV0();
            decodedAuthenticatedMessageV0.sequence = Uint64.decode(stream);
            decodedAuthenticatedMessageV0.message = StellarMessage.decode(stream);
            decodedAuthenticatedMessageV0.mac = HmacSha256Mac.decode(stream);
            return decodedAuthenticatedMessageV0;
        }

        public int hashCode() {
            return Objects.hash(this.sequence, this.message, this.mac);
        }

        public boolean equals(Object object) {
            if (!(object instanceof AuthenticatedMessageV0)) {
                return false;
            }
            AuthenticatedMessageV0 other = (AuthenticatedMessageV0)object;
            return Objects.equals(this.sequence, other.sequence) && Objects.equals(this.message, other.message) && Objects.equals(this.mac, other.mac);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static AuthenticatedMessageV0 fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AuthenticatedMessageV0.fromXdrByteArray(bytes);
        }

        public static AuthenticatedMessageV0 fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AuthenticatedMessageV0.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Uint64 sequence;
            private StellarMessage message;
            private HmacSha256Mac mac;

            public Builder sequence(Uint64 sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder message(StellarMessage message) {
                this.message = message;
                return this;
            }

            public Builder mac(HmacSha256Mac mac) {
                this.mac = mac;
                return this;
            }

            public AuthenticatedMessageV0 build() {
                AuthenticatedMessageV0 val = new AuthenticatedMessageV0();
                val.setSequence(this.sequence);
                val.setMessage(this.message);
                val.setMac(this.mac);
                return val;
            }
        }
    }

    public static final class Builder {
        private Uint32 discriminant;
        private AuthenticatedMessageV0 v0;

        public Builder discriminant(Uint32 discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(AuthenticatedMessageV0 v0) {
            this.v0 = v0;
            return this;
        }

        public AuthenticatedMessage build() {
            AuthenticatedMessage val = new AuthenticatedMessage();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            return val;
        }
    }
}

