/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BucketEntryType;
import org.stellar.sdk.xdr.BucketMetadata;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BucketEntry
implements XdrElement {
    BucketEntryType type;
    private LedgerEntry liveEntry;
    private LedgerKey deadEntry;
    private BucketMetadata metaEntry;

    public BucketEntryType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(BucketEntryType value) {
        this.type = value;
    }

    public LedgerEntry getLiveEntry() {
        return this.liveEntry;
    }

    public void setLiveEntry(LedgerEntry value) {
        this.liveEntry = value;
    }

    public LedgerKey getDeadEntry() {
        return this.deadEntry;
    }

    public void setDeadEntry(LedgerKey value) {
        this.deadEntry = value;
    }

    public BucketMetadata getMetaEntry() {
        return this.metaEntry;
    }

    public void setMetaEntry(BucketMetadata value) {
        this.metaEntry = value;
    }

    public static void encode(XdrDataOutputStream stream, BucketEntry encodedBucketEntry) throws IOException {
        stream.writeInt(encodedBucketEntry.getDiscriminant().getValue());
        switch (encodedBucketEntry.getDiscriminant()) {
            case LIVEENTRY: 
            case INITENTRY: {
                LedgerEntry.encode(stream, encodedBucketEntry.liveEntry);
                break;
            }
            case DEADENTRY: {
                LedgerKey.encode(stream, encodedBucketEntry.deadEntry);
                break;
            }
            case METAENTRY: {
                BucketMetadata.encode(stream, encodedBucketEntry.metaEntry);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        BucketEntry.encode(stream, this);
    }

    public static BucketEntry decode(XdrDataInputStream stream) throws IOException {
        BucketEntry decodedBucketEntry = new BucketEntry();
        BucketEntryType discriminant = BucketEntryType.decode(stream);
        decodedBucketEntry.setDiscriminant(discriminant);
        switch (decodedBucketEntry.getDiscriminant()) {
            case LIVEENTRY: 
            case INITENTRY: {
                decodedBucketEntry.liveEntry = LedgerEntry.decode(stream);
                break;
            }
            case DEADENTRY: {
                decodedBucketEntry.deadEntry = LedgerKey.decode(stream);
                break;
            }
            case METAENTRY: {
                decodedBucketEntry.metaEntry = BucketMetadata.decode(stream);
            }
        }
        return decodedBucketEntry;
    }

    public int hashCode() {
        return Objects.hash(this.liveEntry, this.deadEntry, this.metaEntry, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BucketEntry)) {
            return false;
        }
        BucketEntry other = (BucketEntry)object;
        return Objects.equals(this.liveEntry, other.liveEntry) && Objects.equals(this.deadEntry, other.deadEntry) && Objects.equals(this.metaEntry, other.metaEntry) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static BucketEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BucketEntry.fromXdrByteArray(bytes);
    }

    public static BucketEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BucketEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private BucketEntryType discriminant;
        private LedgerEntry liveEntry;
        private LedgerKey deadEntry;
        private BucketMetadata metaEntry;

        public Builder discriminant(BucketEntryType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder liveEntry(LedgerEntry liveEntry) {
            this.liveEntry = liveEntry;
            return this;
        }

        public Builder deadEntry(LedgerKey deadEntry) {
            this.deadEntry = deadEntry;
            return this;
        }

        public Builder metaEntry(BucketMetadata metaEntry) {
            this.metaEntry = metaEntry;
            return this;
        }

        public BucketEntry build() {
            BucketEntry val = new BucketEntry();
            val.setDiscriminant(this.discriminant);
            val.setLiveEntry(this.liveEntry);
            val.setDeadEntry(this.deadEntry);
            val.setMetaEntry(this.metaEntry);
            return val;
        }
    }
}

