/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BucketMetadata
implements XdrElement {
    private Uint32 ledgerVersion;
    private BucketMetadataExt ext;

    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    public void setLedgerVersion(Uint32 value) {
        this.ledgerVersion = value;
    }

    public BucketMetadataExt getExt() {
        return this.ext;
    }

    public void setExt(BucketMetadataExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, BucketMetadata encodedBucketMetadata) throws IOException {
        Uint32.encode(stream, encodedBucketMetadata.ledgerVersion);
        BucketMetadataExt.encode(stream, encodedBucketMetadata.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        BucketMetadata.encode(stream, this);
    }

    public static BucketMetadata decode(XdrDataInputStream stream) throws IOException {
        BucketMetadata decodedBucketMetadata = new BucketMetadata();
        decodedBucketMetadata.ledgerVersion = Uint32.decode(stream);
        decodedBucketMetadata.ext = BucketMetadataExt.decode(stream);
        return decodedBucketMetadata;
    }

    public int hashCode() {
        return Objects.hash(this.ledgerVersion, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BucketMetadata)) {
            return false;
        }
        BucketMetadata other = (BucketMetadata)object;
        return Objects.equals(this.ledgerVersion, other.ledgerVersion) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static BucketMetadata fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BucketMetadata.fromXdrByteArray(bytes);
    }

    public static BucketMetadata fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BucketMetadata.decode(xdrDataInputStream);
    }

    public static class BucketMetadataExt
    implements XdrElement {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, BucketMetadataExt encodedBucketMetadataExt) throws IOException {
            stream.writeInt(encodedBucketMetadataExt.getDiscriminant());
            switch (encodedBucketMetadataExt.getDiscriminant()) {
                default: 
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            BucketMetadataExt.encode(stream, this);
        }

        public static BucketMetadataExt decode(XdrDataInputStream stream) throws IOException {
            BucketMetadataExt decodedBucketMetadataExt = new BucketMetadataExt();
            Integer discriminant = stream.readInt();
            decodedBucketMetadataExt.setDiscriminant(discriminant);
            switch (decodedBucketMetadataExt.getDiscriminant()) {
                default: 
            }
            return decodedBucketMetadataExt;
        }

        public int hashCode() {
            return Objects.hash(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof BucketMetadataExt)) {
                return false;
            }
            BucketMetadataExt other = (BucketMetadataExt)object;
            return Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static BucketMetadataExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return BucketMetadataExt.fromXdrByteArray(bytes);
        }

        public static BucketMetadataExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return BucketMetadataExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public BucketMetadataExt build() {
                BucketMetadataExt val = new BucketMetadataExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private Uint32 ledgerVersion;
        private BucketMetadataExt ext;

        public Builder ledgerVersion(Uint32 ledgerVersion) {
            this.ledgerVersion = ledgerVersion;
            return this;
        }

        public Builder ext(BucketMetadataExt ext) {
            this.ext = ext;
            return this;
        }

        public BucketMetadata build() {
            BucketMetadata val = new BucketMetadata();
            val.setLedgerVersion(this.ledgerVersion);
            val.setExt(this.ext);
            return val;
        }
    }
}

