/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BumpSequenceResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BumpSequenceResult
implements XdrElement {
    BumpSequenceResultCode code;

    public BumpSequenceResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(BumpSequenceResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, BumpSequenceResult encodedBumpSequenceResult) throws IOException {
        stream.writeInt(encodedBumpSequenceResult.getDiscriminant().getValue());
        switch (encodedBumpSequenceResult.getDiscriminant()) {
            case BUMP_SEQUENCE_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        BumpSequenceResult.encode(stream, this);
    }

    public static BumpSequenceResult decode(XdrDataInputStream stream) throws IOException {
        BumpSequenceResult decodedBumpSequenceResult = new BumpSequenceResult();
        BumpSequenceResultCode discriminant = BumpSequenceResultCode.decode(stream);
        decodedBumpSequenceResult.setDiscriminant(discriminant);
        switch (decodedBumpSequenceResult.getDiscriminant()) {
            case BUMP_SEQUENCE_SUCCESS: {
                break;
            }
        }
        return decodedBumpSequenceResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BumpSequenceResult)) {
            return false;
        }
        BumpSequenceResult other = (BumpSequenceResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static BumpSequenceResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BumpSequenceResult.fromXdrByteArray(bytes);
    }

    public static BumpSequenceResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BumpSequenceResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private BumpSequenceResultCode discriminant;

        public Builder discriminant(BumpSequenceResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public BumpSequenceResult build() {
            BumpSequenceResult val = new BumpSequenceResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

