/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ChangeTrustResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ChangeTrustResult
implements XdrElement {
    ChangeTrustResultCode code;

    public ChangeTrustResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(ChangeTrustResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, ChangeTrustResult encodedChangeTrustResult) throws IOException {
        stream.writeInt(encodedChangeTrustResult.getDiscriminant().getValue());
        switch (encodedChangeTrustResult.getDiscriminant()) {
            case CHANGE_TRUST_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ChangeTrustResult.encode(stream, this);
    }

    public static ChangeTrustResult decode(XdrDataInputStream stream) throws IOException {
        ChangeTrustResult decodedChangeTrustResult = new ChangeTrustResult();
        ChangeTrustResultCode discriminant = ChangeTrustResultCode.decode(stream);
        decodedChangeTrustResult.setDiscriminant(discriminant);
        switch (decodedChangeTrustResult.getDiscriminant()) {
            case CHANGE_TRUST_SUCCESS: {
                break;
            }
        }
        return decodedChangeTrustResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChangeTrustResult)) {
            return false;
        }
        ChangeTrustResult other = (ChangeTrustResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ChangeTrustResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ChangeTrustResult.fromXdrByteArray(bytes);
    }

    public static ChangeTrustResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ChangeTrustResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ChangeTrustResultCode discriminant;

        public Builder discriminant(ChangeTrustResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public ChangeTrustResult build() {
            ChangeTrustResult val = new ChangeTrustResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

