/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimableBalanceEntryExtensionV1;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimableBalanceEntry
implements XdrElement {
    private ClaimableBalanceID balanceID;
    private Claimant[] claimants;
    private Asset asset;
    private Int64 amount;
    private ClaimableBalanceEntryExt ext;

    public ClaimableBalanceID getBalanceID() {
        return this.balanceID;
    }

    public void setBalanceID(ClaimableBalanceID value) {
        this.balanceID = value;
    }

    public Claimant[] getClaimants() {
        return this.claimants;
    }

    public void setClaimants(Claimant[] value) {
        this.claimants = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public ClaimableBalanceEntryExt getExt() {
        return this.ext;
    }

    public void setExt(ClaimableBalanceEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimableBalanceEntry encodedClaimableBalanceEntry) throws IOException {
        ClaimableBalanceID.encode(stream, encodedClaimableBalanceEntry.balanceID);
        int claimantssize = encodedClaimableBalanceEntry.getClaimants().length;
        stream.writeInt(claimantssize);
        for (int i = 0; i < claimantssize; ++i) {
            Claimant.encode(stream, encodedClaimableBalanceEntry.claimants[i]);
        }
        Asset.encode(stream, encodedClaimableBalanceEntry.asset);
        Int64.encode(stream, encodedClaimableBalanceEntry.amount);
        ClaimableBalanceEntryExt.encode(stream, encodedClaimableBalanceEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimableBalanceEntry.encode(stream, this);
    }

    public static ClaimableBalanceEntry decode(XdrDataInputStream stream) throws IOException {
        ClaimableBalanceEntry decodedClaimableBalanceEntry = new ClaimableBalanceEntry();
        decodedClaimableBalanceEntry.balanceID = ClaimableBalanceID.decode(stream);
        int claimantssize = stream.readInt();
        decodedClaimableBalanceEntry.claimants = new Claimant[claimantssize];
        for (int i = 0; i < claimantssize; ++i) {
            decodedClaimableBalanceEntry.claimants[i] = Claimant.decode(stream);
        }
        decodedClaimableBalanceEntry.asset = Asset.decode(stream);
        decodedClaimableBalanceEntry.amount = Int64.decode(stream);
        decodedClaimableBalanceEntry.ext = ClaimableBalanceEntryExt.decode(stream);
        return decodedClaimableBalanceEntry;
    }

    public int hashCode() {
        return Objects.hash(this.balanceID, Arrays.hashCode(this.claimants), this.asset, this.amount, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimableBalanceEntry)) {
            return false;
        }
        ClaimableBalanceEntry other = (ClaimableBalanceEntry)object;
        return Objects.equals(this.balanceID, other.balanceID) && Arrays.equals(this.claimants, other.claimants) && Objects.equals(this.asset, other.asset) && Objects.equals(this.amount, other.amount) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClaimableBalanceEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimableBalanceEntry.fromXdrByteArray(bytes);
    }

    public static ClaimableBalanceEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimableBalanceEntry.decode(xdrDataInputStream);
    }

    public static class ClaimableBalanceEntryExt
    implements XdrElement {
        Integer v;
        private ClaimableBalanceEntryExtensionV1 v1;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public ClaimableBalanceEntryExtensionV1 getV1() {
            return this.v1;
        }

        public void setV1(ClaimableBalanceEntryExtensionV1 value) {
            this.v1 = value;
        }

        public static void encode(XdrDataOutputStream stream, ClaimableBalanceEntryExt encodedClaimableBalanceEntryExt) throws IOException {
            stream.writeInt(encodedClaimableBalanceEntryExt.getDiscriminant());
            switch (encodedClaimableBalanceEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    ClaimableBalanceEntryExtensionV1.encode(stream, encodedClaimableBalanceEntryExt.v1);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            ClaimableBalanceEntryExt.encode(stream, this);
        }

        public static ClaimableBalanceEntryExt decode(XdrDataInputStream stream) throws IOException {
            ClaimableBalanceEntryExt decodedClaimableBalanceEntryExt = new ClaimableBalanceEntryExt();
            Integer discriminant = stream.readInt();
            decodedClaimableBalanceEntryExt.setDiscriminant(discriminant);
            switch (decodedClaimableBalanceEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedClaimableBalanceEntryExt.v1 = ClaimableBalanceEntryExtensionV1.decode(stream);
                }
            }
            return decodedClaimableBalanceEntryExt;
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClaimableBalanceEntryExt)) {
                return false;
            }
            ClaimableBalanceEntryExt other = (ClaimableBalanceEntryExt)object;
            return Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static ClaimableBalanceEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ClaimableBalanceEntryExt.fromXdrByteArray(bytes);
        }

        public static ClaimableBalanceEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ClaimableBalanceEntryExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;
            private ClaimableBalanceEntryExtensionV1 v1;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder v1(ClaimableBalanceEntryExtensionV1 v1) {
                this.v1 = v1;
                return this;
            }

            public ClaimableBalanceEntryExt build() {
                ClaimableBalanceEntryExt val = new ClaimableBalanceEntryExt();
                val.setDiscriminant(this.discriminant);
                val.setV1(this.v1);
                return val;
            }
        }
    }

    public static final class Builder {
        private ClaimableBalanceID balanceID;
        private Claimant[] claimants;
        private Asset asset;
        private Int64 amount;
        private ClaimableBalanceEntryExt ext;

        public Builder balanceID(ClaimableBalanceID balanceID) {
            this.balanceID = balanceID;
            return this;
        }

        public Builder claimants(Claimant[] claimants) {
            this.claimants = claimants;
            return this;
        }

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public Builder ext(ClaimableBalanceEntryExt ext) {
            this.ext = ext;
            return this;
        }

        public ClaimableBalanceEntry build() {
            ClaimableBalanceEntry val = new ClaimableBalanceEntry();
            val.setBalanceID(this.balanceID);
            val.setClaimants(this.claimants);
            val.setAsset(this.asset);
            val.setAmount(this.amount);
            val.setExt(this.ext);
            return val;
        }
    }
}

