/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ClawbackResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClawbackResult
implements XdrElement {
    ClawbackResultCode code;

    public ClawbackResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(ClawbackResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, ClawbackResult encodedClawbackResult) throws IOException {
        stream.writeInt(encodedClawbackResult.getDiscriminant().getValue());
        switch (encodedClawbackResult.getDiscriminant()) {
            case CLAWBACK_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClawbackResult.encode(stream, this);
    }

    public static ClawbackResult decode(XdrDataInputStream stream) throws IOException {
        ClawbackResult decodedClawbackResult = new ClawbackResult();
        ClawbackResultCode discriminant = ClawbackResultCode.decode(stream);
        decodedClawbackResult.setDiscriminant(discriminant);
        switch (decodedClawbackResult.getDiscriminant()) {
            case CLAWBACK_SUCCESS: {
                break;
            }
        }
        return decodedClawbackResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClawbackResult)) {
            return false;
        }
        ClawbackResult other = (ClawbackResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClawbackResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClawbackResult.fromXdrByteArray(bytes);
    }

    public static ClawbackResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClawbackResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ClawbackResultCode discriminant;

        public Builder discriminant(ClawbackResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public ClawbackResult build() {
            ClawbackResult val = new ClawbackResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

