/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractCodeCostInputs
implements XdrElement {
    private ExtensionPoint ext;
    private Uint32 nInstructions;
    private Uint32 nFunctions;
    private Uint32 nGlobals;
    private Uint32 nTableEntries;
    private Uint32 nTypes;
    private Uint32 nDataSegments;
    private Uint32 nElemSegments;
    private Uint32 nImports;
    private Uint32 nExports;
    private Uint32 nDataSegmentBytes;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Uint32 getNInstructions() {
        return this.nInstructions;
    }

    public void setNInstructions(Uint32 value) {
        this.nInstructions = value;
    }

    public Uint32 getNFunctions() {
        return this.nFunctions;
    }

    public void setNFunctions(Uint32 value) {
        this.nFunctions = value;
    }

    public Uint32 getNGlobals() {
        return this.nGlobals;
    }

    public void setNGlobals(Uint32 value) {
        this.nGlobals = value;
    }

    public Uint32 getNTableEntries() {
        return this.nTableEntries;
    }

    public void setNTableEntries(Uint32 value) {
        this.nTableEntries = value;
    }

    public Uint32 getNTypes() {
        return this.nTypes;
    }

    public void setNTypes(Uint32 value) {
        this.nTypes = value;
    }

    public Uint32 getNDataSegments() {
        return this.nDataSegments;
    }

    public void setNDataSegments(Uint32 value) {
        this.nDataSegments = value;
    }

    public Uint32 getNElemSegments() {
        return this.nElemSegments;
    }

    public void setNElemSegments(Uint32 value) {
        this.nElemSegments = value;
    }

    public Uint32 getNImports() {
        return this.nImports;
    }

    public void setNImports(Uint32 value) {
        this.nImports = value;
    }

    public Uint32 getNExports() {
        return this.nExports;
    }

    public void setNExports(Uint32 value) {
        this.nExports = value;
    }

    public Uint32 getNDataSegmentBytes() {
        return this.nDataSegmentBytes;
    }

    public void setNDataSegmentBytes(Uint32 value) {
        this.nDataSegmentBytes = value;
    }

    public static void encode(XdrDataOutputStream stream, ContractCodeCostInputs encodedContractCodeCostInputs) throws IOException {
        ExtensionPoint.encode(stream, encodedContractCodeCostInputs.ext);
        Uint32.encode(stream, encodedContractCodeCostInputs.nInstructions);
        Uint32.encode(stream, encodedContractCodeCostInputs.nFunctions);
        Uint32.encode(stream, encodedContractCodeCostInputs.nGlobals);
        Uint32.encode(stream, encodedContractCodeCostInputs.nTableEntries);
        Uint32.encode(stream, encodedContractCodeCostInputs.nTypes);
        Uint32.encode(stream, encodedContractCodeCostInputs.nDataSegments);
        Uint32.encode(stream, encodedContractCodeCostInputs.nElemSegments);
        Uint32.encode(stream, encodedContractCodeCostInputs.nImports);
        Uint32.encode(stream, encodedContractCodeCostInputs.nExports);
        Uint32.encode(stream, encodedContractCodeCostInputs.nDataSegmentBytes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ContractCodeCostInputs.encode(stream, this);
    }

    public static ContractCodeCostInputs decode(XdrDataInputStream stream) throws IOException {
        ContractCodeCostInputs decodedContractCodeCostInputs = new ContractCodeCostInputs();
        decodedContractCodeCostInputs.ext = ExtensionPoint.decode(stream);
        decodedContractCodeCostInputs.nInstructions = Uint32.decode(stream);
        decodedContractCodeCostInputs.nFunctions = Uint32.decode(stream);
        decodedContractCodeCostInputs.nGlobals = Uint32.decode(stream);
        decodedContractCodeCostInputs.nTableEntries = Uint32.decode(stream);
        decodedContractCodeCostInputs.nTypes = Uint32.decode(stream);
        decodedContractCodeCostInputs.nDataSegments = Uint32.decode(stream);
        decodedContractCodeCostInputs.nElemSegments = Uint32.decode(stream);
        decodedContractCodeCostInputs.nImports = Uint32.decode(stream);
        decodedContractCodeCostInputs.nExports = Uint32.decode(stream);
        decodedContractCodeCostInputs.nDataSegmentBytes = Uint32.decode(stream);
        return decodedContractCodeCostInputs;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.nInstructions, this.nFunctions, this.nGlobals, this.nTableEntries, this.nTypes, this.nDataSegments, this.nElemSegments, this.nImports, this.nExports, this.nDataSegmentBytes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContractCodeCostInputs)) {
            return false;
        }
        ContractCodeCostInputs other = (ContractCodeCostInputs)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.nInstructions, other.nInstructions) && Objects.equals(this.nFunctions, other.nFunctions) && Objects.equals(this.nGlobals, other.nGlobals) && Objects.equals(this.nTableEntries, other.nTableEntries) && Objects.equals(this.nTypes, other.nTypes) && Objects.equals(this.nDataSegments, other.nDataSegments) && Objects.equals(this.nElemSegments, other.nElemSegments) && Objects.equals(this.nImports, other.nImports) && Objects.equals(this.nExports, other.nExports) && Objects.equals(this.nDataSegmentBytes, other.nDataSegmentBytes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ContractCodeCostInputs fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCodeCostInputs.fromXdrByteArray(bytes);
    }

    public static ContractCodeCostInputs fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCodeCostInputs.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Uint32 nInstructions;
        private Uint32 nFunctions;
        private Uint32 nGlobals;
        private Uint32 nTableEntries;
        private Uint32 nTypes;
        private Uint32 nDataSegments;
        private Uint32 nElemSegments;
        private Uint32 nImports;
        private Uint32 nExports;
        private Uint32 nDataSegmentBytes;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder nInstructions(Uint32 nInstructions) {
            this.nInstructions = nInstructions;
            return this;
        }

        public Builder nFunctions(Uint32 nFunctions) {
            this.nFunctions = nFunctions;
            return this;
        }

        public Builder nGlobals(Uint32 nGlobals) {
            this.nGlobals = nGlobals;
            return this;
        }

        public Builder nTableEntries(Uint32 nTableEntries) {
            this.nTableEntries = nTableEntries;
            return this;
        }

        public Builder nTypes(Uint32 nTypes) {
            this.nTypes = nTypes;
            return this;
        }

        public Builder nDataSegments(Uint32 nDataSegments) {
            this.nDataSegments = nDataSegments;
            return this;
        }

        public Builder nElemSegments(Uint32 nElemSegments) {
            this.nElemSegments = nElemSegments;
            return this;
        }

        public Builder nImports(Uint32 nImports) {
            this.nImports = nImports;
            return this;
        }

        public Builder nExports(Uint32 nExports) {
            this.nExports = nExports;
            return this;
        }

        public Builder nDataSegmentBytes(Uint32 nDataSegmentBytes) {
            this.nDataSegmentBytes = nDataSegmentBytes;
            return this;
        }

        public ContractCodeCostInputs build() {
            ContractCodeCostInputs val = new ContractCodeCostInputs();
            val.setExt(this.ext);
            val.setNInstructions(this.nInstructions);
            val.setNFunctions(this.nFunctions);
            val.setNGlobals(this.nGlobals);
            val.setNTableEntries(this.nTableEntries);
            val.setNTypes(this.nTypes);
            val.setNDataSegments(this.nDataSegments);
            val.setNElemSegments(this.nElemSegments);
            val.setNImports(this.nImports);
            val.setNExports(this.nExports);
            val.setNDataSegmentBytes(this.nDataSegmentBytes);
            return val;
        }
    }
}

