/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractExecutableType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractExecutable
implements XdrElement {
    ContractExecutableType type;
    private Hash wasm_hash;

    public ContractExecutableType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ContractExecutableType value) {
        this.type = value;
    }

    public Hash getWasm_hash() {
        return this.wasm_hash;
    }

    public void setWasm_hash(Hash value) {
        this.wasm_hash = value;
    }

    public static void encode(XdrDataOutputStream stream, ContractExecutable encodedContractExecutable) throws IOException {
        stream.writeInt(encodedContractExecutable.getDiscriminant().getValue());
        switch (encodedContractExecutable.getDiscriminant()) {
            case CONTRACT_EXECUTABLE_WASM: {
                Hash.encode(stream, encodedContractExecutable.wasm_hash);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ContractExecutable.encode(stream, this);
    }

    public static ContractExecutable decode(XdrDataInputStream stream) throws IOException {
        ContractExecutable decodedContractExecutable = new ContractExecutable();
        ContractExecutableType discriminant = ContractExecutableType.decode(stream);
        decodedContractExecutable.setDiscriminant(discriminant);
        switch (decodedContractExecutable.getDiscriminant()) {
            case CONTRACT_EXECUTABLE_WASM: {
                decodedContractExecutable.wasm_hash = Hash.decode(stream);
                break;
            }
        }
        return decodedContractExecutable;
    }

    public int hashCode() {
        return Objects.hash(this.wasm_hash, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContractExecutable)) {
            return false;
        }
        ContractExecutable other = (ContractExecutable)object;
        return Objects.equals(this.wasm_hash, other.wasm_hash) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ContractExecutable fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractExecutable.fromXdrByteArray(bytes);
    }

    public static ContractExecutable fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractExecutable.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ContractExecutableType discriminant;
        private Hash wasm_hash;

        public Builder discriminant(ContractExecutableType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder wasm_hash(Hash wasm_hash) {
            this.wasm_hash = wasm_hash;
            return this;
        }

        public ContractExecutable build() {
            ContractExecutable val = new ContractExecutable();
            val.setDiscriminant(this.discriminant);
            val.setWasm_hash(this.wasm_hash);
            return val;
        }
    }
}

