/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum CreateClaimableBalanceResultCode implements XdrElement
{
    CREATE_CLAIMABLE_BALANCE_SUCCESS(0),
    CREATE_CLAIMABLE_BALANCE_MALFORMED(-1),
    CREATE_CLAIMABLE_BALANCE_LOW_RESERVE(-2),
    CREATE_CLAIMABLE_BALANCE_NO_TRUST(-3),
    CREATE_CLAIMABLE_BALANCE_NOT_AUTHORIZED(-4),
    CREATE_CLAIMABLE_BALANCE_UNDERFUNDED(-5);

    private int mValue;

    private CreateClaimableBalanceResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static CreateClaimableBalanceResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CREATE_CLAIMABLE_BALANCE_SUCCESS;
            }
            case -1: {
                return CREATE_CLAIMABLE_BALANCE_MALFORMED;
            }
            case -2: {
                return CREATE_CLAIMABLE_BALANCE_LOW_RESERVE;
            }
            case -3: {
                return CREATE_CLAIMABLE_BALANCE_NO_TRUST;
            }
            case -4: {
                return CREATE_CLAIMABLE_BALANCE_NOT_AUTHORIZED;
            }
            case -5: {
                return CREATE_CLAIMABLE_BALANCE_UNDERFUNDED;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, CreateClaimableBalanceResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreateClaimableBalanceResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static CreateClaimableBalanceResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateClaimableBalanceResultCode.fromXdrByteArray(bytes);
    }

    public static CreateClaimableBalanceResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateClaimableBalanceResultCode.decode(xdrDataInputStream);
    }
}

