/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DecoratedSignature
implements XdrElement {
    private SignatureHint hint;
    private Signature signature;

    public SignatureHint getHint() {
        return this.hint;
    }

    public void setHint(SignatureHint value) {
        this.hint = value;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature value) {
        this.signature = value;
    }

    public static void encode(XdrDataOutputStream stream, DecoratedSignature encodedDecoratedSignature) throws IOException {
        SignatureHint.encode(stream, encodedDecoratedSignature.hint);
        Signature.encode(stream, encodedDecoratedSignature.signature);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        DecoratedSignature.encode(stream, this);
    }

    public static DecoratedSignature decode(XdrDataInputStream stream) throws IOException {
        DecoratedSignature decodedDecoratedSignature = new DecoratedSignature();
        decodedDecoratedSignature.hint = SignatureHint.decode(stream);
        decodedDecoratedSignature.signature = Signature.decode(stream);
        return decodedDecoratedSignature;
    }

    public int hashCode() {
        return Objects.hash(this.hint, this.signature);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecoratedSignature)) {
            return false;
        }
        DecoratedSignature other = (DecoratedSignature)object;
        return Objects.equals(this.hint, other.hint) && Objects.equals(this.signature, other.signature);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static DecoratedSignature fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DecoratedSignature.fromXdrByteArray(bytes);
    }

    public static DecoratedSignature fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DecoratedSignature.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SignatureHint hint;
        private Signature signature;

        public Builder hint(SignatureHint hint) {
            this.hint = hint;
            return this;
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public DecoratedSignature build() {
            DecoratedSignature val = new DecoratedSignature();
            val.setHint(this.hint);
            val.setSignature(this.signature);
            return val;
        }
    }
}

